/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.util.Signal;
import java.util.Collections;
import java.util.List;
import org.infinispan.hotrod.impl.transport.netty.HintingByteBuf;

public abstract class HintedReplayingDecoder<S>
extends ByteToMessageDecoder {
    public static final Signal REPLAY = Signal.valueOf((String)(HintedReplayingDecoder.class.getName() + ".REPLAY"));
    private static final List<Object> NO_WRITE_LIST = Collections.emptyList();
    final HintingByteBuf replayable = new HintingByteBuf(this);
    private S state;
    private int checkpoint = -1;
    private int requiredReadableBytes = 0;

    protected HintedReplayingDecoder() {
        this(null);
    }

    protected HintedReplayingDecoder(S initialState) {
        this.state = initialState;
    }

    protected void checkpoint() {
        this.checkpoint = this.replayable.buffer != null ? this.replayable.buffer.readerIndex() : this.internalBuffer().readerIndex();
    }

    protected void checkpoint(S state) {
        this.checkpoint();
        this.state(state);
    }

    protected S state() {
        return this.state;
    }

    protected abstract boolean isHandlingMessage();

    protected S state(S newState) {
        S oldState = this.state;
        this.state = newState;
        return oldState;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.replayable.terminate();
        super.channelInactive(ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void callDecode(ChannelHandlerContext ctx, ByteBuf in, List<Object> xxx) {
        if (in.readableBytes() < this.requiredReadableBytes) {
            return;
        }
        this.replayable.setCumulation(in);
        try {
            while (this.isHandlingMessage() && in.isReadable() && !ctx.isRemoved() && ctx.channel().isActive()) {
                this.checkpoint = in.readerIndex();
                try {
                    this.decode(ctx, this.replayable, NO_WRITE_LIST);
                    this.requiredReadableBytes = 0;
                }
                catch (Signal replay) {
                    replay.expect(REPLAY);
                    if (ctx.isRemoved()) {
                        return;
                    } else {
                        int checkpoint = this.checkpoint;
                        if (checkpoint < 0) return;
                        in.readerIndex(checkpoint);
                        return;
                    }
                }
                catch (Throwable t) {
                    this.requiredReadableBytes = 0;
                    throw t;
                    return;
                }
            }
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new DecoderException(cause);
        }
        finally {
            this.replayable.setCumulation(null);
        }
    }

    void checkAndAdvance(ByteBuf buf) {
        if (this.checkpoint >= 0) {
            buf.readerIndex(this.checkpoint);
        }
    }

    void requireWriterIndex(int index) {
        this.requiredReadableBytes = index - this.checkpoint;
    }
}

