/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.hotrod.impl.counter.operation.BaseCounterOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class GetCounterNamesOperation
extends BaseCounterOperation<Collection<String>> {
    private int size;
    private Collection<String> names;

    public GetCounterNamesOperation(OperationContext operationContext) {
        super(operationContext, (short)100, (short)101, "", false);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        this.sendHeader(channel);
        this.setCacheName();
    }

    @Override
    protected void reset() {
        super.reset();
        this.names = null;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        assert (status == 0);
        if (this.names == null) {
            this.size = ByteBufUtil.readVInt(buf);
            this.names = new ArrayList<String>(this.size);
            decoder.checkpoint();
        }
        while (this.names.size() < this.size) {
            this.names.add(ByteBufUtil.readString(buf));
            decoder.checkpoint();
        }
        this.complete(this.names);
    }
}

