/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.PingResponse;
import org.infinispan.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class FaultTolerantPingOperation
extends RetryOnFailureOperation<PingResponse> {
    protected FaultTolerantPingOperation(OperationContext operationContext, CacheOptions options) {
        super(operationContext, (short)23, (short)24, options, null);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.sendHeaderAndRead(channel);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        throw new IllegalStateException("Fault tolerant ping not called manually.");
    }

    @Override
    protected Throwable handleException(Throwable cause, Channel channel, SocketAddress address) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        PingResponse pingResponse = new PingResponse(cause);
        if (pingResponse.isCacheNotFound()) {
            this.complete(pingResponse);
            return null;
        }
        return super.handleException(cause, channel, address);
    }
}

