/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.cache.ServerStatistics;
import org.infinispan.hotrod.impl.cache.ServerStatisticsImpl;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class StatsOperation
extends RetryOnFailureOperation<ServerStatistics> {
    private ServerStatisticsImpl result;
    private int numStats = -1;

    public StatsOperation(OperationContext operationContext, CacheOptions options) {
        super(operationContext, (short)21, (short)22, options, null);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.sendHeaderAndRead(channel);
    }

    @Override
    protected void reset() {
        super.reset();
        this.result = null;
        this.numStats = -1;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (this.numStats < 0) {
            this.numStats = ByteBufUtil.readVInt(buf);
            this.result = new ServerStatisticsImpl();
            decoder.checkpoint();
        }
        while (this.result.size() < this.numStats) {
            String statName = ByteBufUtil.readString(buf);
            String statValue = ByteBufUtil.readString(buf);
            this.result.addStats(statName, statValue);
            decoder.checkpoint();
        }
        this.complete(this.result);
    }
}

