/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.util.Signal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.hotrod.configuration.ClientIntelligence;
import org.infinispan.hotrod.impl.operations.HotRodOperation;
import org.infinispan.hotrod.impl.transport.handler.CacheRequestProcessor;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.hotrod.impl.transport.netty.HintedReplayingDecoder;

abstract class ClientBaseDecoder
extends ByteToMessageDecoder {
    protected static final Log log = LogFactory.getLog(ClientBaseDecoder.class);
    public static final Signal DELEGATE = Signal.valueOf((String)(ClientBaseDecoder.class.getName() + ".DELEGATE"));
    protected final HeaderDecoder delegate;
    protected final CacheRequestProcessor responseHandler;

    ClientBaseDecoder(HeaderDecoder delegate, CacheRequestProcessor responseHandler) {
        this.delegate = delegate;
        this.responseHandler = responseHandler;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            this.delegate.exceptionCaught(ctx, cause);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void callDecode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (!this.delegate.isHandlingMessage()) {
            try {
                this.decode(ctx, in, out);
            }
            catch (DecoderException de) {
                throw de;
            }
            catch (Exception e) {
                throw new DecoderException((Throwable)e);
            }
        }
        if (this.delegate.isHandlingMessage()) {
            this.callInverseDecode(ctx, in, out);
        }
    }

    private void callInverseDecode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.delegate.isHandlingMessage()) {
            this.delegate.callDecode(ctx, in, out);
        }
        if (!this.delegate.isHandlingMessage()) {
            this.callDecode(ctx, in, out);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.delegate.channelInactive(ctx);
    }

    public boolean isSharable() {
        return false;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.delegate.userEventTriggered(ctx, evt);
    }

    public void failoverClientListeners() {
        this.delegate.failoverClientListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delegateParsing(ByteBuf buf, long messageId, short opCode, short status) {
        try {
            this.delegate.replayable.setCumulation(buf);
            this.delegate.resumeOperation(this.delegate.replayable, messageId, opCode, status);
        }
        catch (Signal replay) {
            replay.expect(HintedReplayingDecoder.REPLAY);
            this.delegate.checkAndAdvance(buf);
        }
        finally {
            this.delegate.replayable.setCumulation(null);
        }
        if (this.delegate.isHandlingMessage()) {
            throw DELEGATE;
        }
    }

    protected boolean operationResponseHasError(long messageId, short opCode) {
        HotRodOperation<?> op = this.delegate.operation;
        if (op.header().responseCode() != opCode) {
            if (opCode == 80) {
                return true;
            }
            throw org.infinispan.hotrod.impl.logging.Log.HOTROD.invalidResponse(new String(op.header().cacheName()), op.header().responseCode(), opCode);
        }
        return false;
    }

    public void removeListener(byte[] id) {
        this.delegate.removeListener(id);
    }

    protected boolean isHashDistributionAware(long messageId) {
        HotRodOperation<?> op = this.delegate.operation;
        return op.header().clientIntelligence() == ClientIntelligence.HASH_DISTRIBUTION_AWARE.getValue();
    }

    public void registerOperation(Channel channel, HotRodOperation<?> op) {
        this.delegate.registerOperation(channel, op);
    }

    public int registeredOperations() {
        return this.delegate.registeredOperations();
    }

    public <T extends HotRodOperation<?>> T current() {
        return (T)this.delegate.operation;
    }

    protected <K, V> Map<K, V> allocMap(int size) {
        return size == 0 ? Collections.emptyMap() : new HashMap(size * 4 / 3, 0.75f);
    }

    protected <T> List<T> allocList(int size) {
        return size == 0 ? Collections.emptyList() : new ArrayList(size);
    }

    protected <T> Set<T> allocSet(int size) {
        return size == 0 ? Collections.emptySet() : new HashSet(size);
    }
}

