/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.hotrod.configuration.HotRodConfigurationBuilder;
import org.infinispan.hotrod.configuration.ServerConfiguration;
import org.infinispan.hotrod.impl.logging.Log;

public class ServerConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ServerConfiguration> {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(\\[([0-9A-Fa-f:]+)\\]|([^:/?#]*))(?::(\\d*))?");
    private final AttributeSet attributes = ServerConfiguration.attributeDefinitionSet();

    ServerConfigurationBuilder(HotRodConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ServerConfigurationBuilder host(String host) {
        this.attributes.attribute(ServerConfiguration.HOST).set((Object)host);
        return this;
    }

    public ServerConfigurationBuilder port(int port) {
        this.attributes.attribute(ServerConfiguration.PORT).set((Object)port);
        return this;
    }

    public void validate() {
    }

    public ServerConfiguration create() {
        return new ServerConfiguration(this.attributes.protect());
    }

    public Builder read(ServerConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public static void parseServers(String servers, BiConsumer<String, Integer> c) {
        for (String server : servers.split(";")) {
            Matcher matcher = ADDRESS_PATTERN.matcher(server.trim());
            if (!matcher.matches()) {
                throw Log.HOTROD.parseErrorServerAddress(server);
            }
            String v6host = matcher.group(2);
            String v4host = matcher.group(3);
            String host = v6host != null ? v6host : v4host;
            String portString = matcher.group(4);
            int port = portString == null ? (Integer)ServerConfiguration.PORT.getDefaultValue() : Integer.parseInt(portString);
            c.accept(host, port);
        }
    }
}

