/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.util;

import io.reactivex.rxjava3.core.Flowable;
import io.smallrye.mutiny.Multi;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public final class FlowUtils {
    private FlowUtils() {
    }

    public static <T> Flowable<T> toFlowable(Flow.Publisher<T> publisher) {
        return Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(publisher));
    }

    public static <T, R, A> R blockingCollect(Flowable<T> flowable, Collector<? super T, A, R> collector) {
        return (R)flowable.collect(collector).timeout(10L, TimeUnit.SECONDS).blockingGet();
    }

    public static <T, R, A> R blockingCollect(Flow.Publisher<T> publisher, Collector<? super T, A, R> collector) {
        return FlowUtils.blockingCollect(FlowUtils.toFlowable(publisher), collector);
    }

    public static <T> List<T> blockingCollect(Flow.Publisher<T> publisher) {
        return FlowUtils.blockingCollect(publisher, Collectors.toList());
    }

    public static <T> List<T> blockingCollect(Multi<T> multi) {
        return (List)multi.collect().asList().await().atMost(Duration.ofSeconds(30L));
    }
}

