/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Set;
import org.infinispan.hotrod.impl.counter.operation.BaseCounterOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.hotrod.impl.transport.netty.HotRodClientDecoder;

public class AddListenerOperation
extends BaseCounterOperation<Boolean> {
    private final byte[] listenerId;
    private final SocketAddress server;
    private Channel channel;

    public AddListenerOperation(OperationContext operationContext, String counterName, byte[] listenerId, SocketAddress server) {
        super(operationContext, (short)90, (short)91, counterName, false);
        this.listenerId = listenerId;
        this.server = server;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.channel = channel;
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, ByteBufUtil.estimateArraySize(this.listenerId));
        ByteBufUtil.writeArray(buf, this.listenerId);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.checkStatus(status);
        if (status != 0) {
            this.complete(false);
        } else {
            decoder.addListener(this.listenerId);
            this.complete(true);
        }
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (this.server == null) {
            super.fetchChannelAndInvoke(retryCount, failedServers);
        } else {
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(this.server, this);
        }
    }

    @Override
    public void releaseChannel(Channel channel) {
        if (this.operationContext.getCodec().allowOperationsAndEvents()) {
            super.releaseChannel(channel);
        }
    }

    public void cleanup() {
        this.channel.eventLoop().execute(() -> {
            HotRodClientDecoder decoder;
            if (log.isTraceEnabled()) {
                log.tracef("Cleanup for %s on %s", this, this.channel);
            }
            if (!this.operationContext.getCodec().allowOperationsAndEvents() && this.channel.isOpen()) {
                super.releaseChannel(this.channel);
            }
            if ((decoder = (HotRodClientDecoder)this.channel.pipeline().get(HotRodClientDecoder.class)) != null) {
                decoder.removeListener(this.listenerId);
            }
        });
    }
}

