/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.multimap.operations;

import io.netty.buffer.ByteBuf;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import net.jcip.annotations.Immutable;
import org.infinispan.api.common.CacheEntryCollection;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.cache.CacheEntryMetadataImpl;
import org.infinispan.hotrod.impl.cache.CacheEntryVersionImpl;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.multimap.metadata.CacheEntryCollectionImpl;
import org.infinispan.hotrod.impl.multimap.operations.AbstractMultimapKeyOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.hotrod.marshall.MarshallerUtil;

@Immutable
public class GetKeyWithMetadataMultimapOperation<K, V>
extends AbstractMultimapKeyOperation<K, CacheEntryCollection<K, V>> {
    private static final Log log = LogFactory.getLog(GetKeyWithMetadataMultimapOperation.class);

    public GetKeyWithMetadataMultimapOperation(OperationContext operationContext, K key, byte[] keyBytes, CacheOptions options, DataFormat dataFormat, boolean supportsDuplicates) {
        super(operationContext, (short)105, (short)106, key, keyBytes, options, dataFormat, supportsDuplicates);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isNotExist(status)) {
            this.complete(new CacheEntryCollectionImpl(this.key, Collections.emptySet()));
            return;
        }
        if (!HotRodConstants.isSuccess(status)) {
            this.complete(null);
            return;
        }
        short flags = buf.readByte();
        long creation = -1L;
        int lifespan = -1;
        long lastUsed = -1L;
        int maxIdle = -1;
        if ((flags & 1) != 1) {
            creation = buf.readLong();
            lifespan = ByteBufUtil.readVInt(buf);
        }
        if ((flags & 2) != 2) {
            lastUsed = buf.readLong();
            maxIdle = ByteBufUtil.readVInt(buf);
        }
        CacheEntryExpiration expiration = lifespan < 0 ? (maxIdle < 0 ? CacheEntryExpiration.IMMORTAL : CacheEntryExpiration.withMaxIdle((Duration)Duration.ofSeconds(maxIdle))) : (maxIdle < 0 ? CacheEntryExpiration.withLifespan((Duration)Duration.ofSeconds(lifespan)) : CacheEntryExpiration.withLifespanAndMaxIdle((Duration)Duration.ofSeconds(lifespan), (Duration)Duration.ofSeconds(maxIdle)));
        CacheEntryVersionImpl version = new CacheEntryVersionImpl(buf.readLong());
        if (log.isTraceEnabled()) {
            log.tracef("Received version: %d", version);
        }
        int size = ByteBufUtil.readVInt(buf);
        ArrayList values = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object value = MarshallerUtil.bytes2obj(this.operationContext.getChannelFactory().getMarshaller(), ByteBufUtil.readArray(buf), this.dataFormat().isObjectStorage(), this.operationContext.getConfiguration().getClassAllowList());
            values.add(value);
        }
        this.complete(new CacheEntryCollectionImpl(this.key, values, new CacheEntryMetadataImpl(creation, lastUsed, expiration, version)));
    }
}

