/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.PingOperation;
import org.infinispan.hotrod.impl.transport.netty.ActivationHandler;
import org.infinispan.hotrod.impl.transport.netty.ChannelRecord;

public class InitialPingHandler
extends ActivationHandler {
    private static final Log log = LogFactory.getLog(InitialPingHandler.class);
    static final String NAME = "initial-ping-handler";
    private final PingOperation ping;

    public InitialPingHandler(PingOperation ping) {
        this.ping = ping;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        if (log.isTraceEnabled()) {
            log.tracef("Activating channel %s", channel);
        }
        ChannelRecord channelRecord = ChannelRecord.of(channel);
        this.ping.invoke(channel);
        this.ping.whenComplete((result, throwable) -> {
            if (log.isTraceEnabled()) {
                log.tracef("Initial ping completed with result %s/%s", result, throwable);
            }
            if (throwable != null) {
                channelRecord.completeExceptionally((Throwable)throwable);
            } else {
                channelRecord.complete(channel);
            }
        });
        ctx.pipeline().remove((ChannelHandler)this);
    }
}

