/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.net.SocketAddress;
import java.util.EnumSet;
import java.util.function.Function;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.hotrod.configuration.ProtocolVersion;
import org.infinispan.hotrod.event.ClientListener;
import org.infinispan.hotrod.event.impl.AbstractClientEvent;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.cache.RemoteCache;
import org.infinispan.hotrod.impl.counter.HotRodCounterEvent;
import org.infinispan.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.hotrod.impl.operations.PingResponse;
import org.infinispan.hotrod.impl.protocol.Codec40;
import org.infinispan.hotrod.impl.protocol.HeaderParams;
import org.infinispan.hotrod.impl.transport.netty.ChannelFactory;

public interface Codec {
    public static Codec forProtocol(ProtocolVersion version) {
        switch (version) {
            case PROTOCOL_VERSION_40: 
            case PROTOCOL_VERSION_AUTO: {
                return new Codec40();
            }
        }
        throw new IllegalArgumentException(version.toString());
    }

    public int estimateHeaderSize(HeaderParams var1);

    public HeaderParams writeHeader(ByteBuf var1, HeaderParams var2);

    public void writeClientListenerParams(ByteBuf var1, ClientListener var2, byte[][] var3, byte[][] var4);

    public void writeExpirationParams(ByteBuf var1, CacheEntryExpiration.Impl var2);

    public void writeBloomFilter(ByteBuf var1, int var2);

    public int estimateExpirationSize(CacheEntryExpiration.Impl var1);

    public long readMessageId(ByteBuf var1);

    public short readOpCode(ByteBuf var1);

    public short readHeader(ByteBuf var1, double var2, HeaderParams var4, ChannelFactory var5, SocketAddress var6);

    public AbstractClientEvent readCacheEvent(ByteBuf var1, Function<byte[], DataFormat> var2, short var3, ClassAllowList var4, SocketAddress var5);

    public <K, V> CacheEntry<K, V> returnPossiblePrevValue(K var1, ByteBuf var2, short var3, DataFormat var4, int var5, ClassAllowList var6, Marshaller var7);

    public void writeClientListenerInterests(ByteBuf var1, EnumSet<CacheEntryEventType> var2);

    public HotRodCounterEvent readCounterEvent(ByteBuf var1);

    default public boolean allowOperationsAndEvents() {
        return false;
    }

    default public int readProjectionSize(ByteBuf buf) {
        return 0;
    }

    default public short readMeta(ByteBuf buf) {
        return 0;
    }

    default public void writeIteratorStartOperation(ByteBuf buf, IntSet segments, String filterConverterFactory, int batchSize, boolean metadata, byte[][] filterParameters) {
        throw new UnsupportedOperationException("This version doesn't support iterating upon entries!");
    }

    default public <K> CloseableIterator<K> keyIterator(RemoteCache<K, ?> remoteCache, CacheOperationsFactory cacheOperationsFactory, CacheOptions options, IntSet segments, int batchSize) {
        throw new UnsupportedOperationException("This version doesn't support iterating upon keys!");
    }

    default public <K, V> CloseableIterator<CacheEntry<K, V>> entryIterator(RemoteCache<K, V> remoteCache, IntSet segments, int batchSize) {
        throw new UnsupportedOperationException("This version doesn't support iterating upon entries!");
    }

    default public MediaType readKeyType(ByteBuf buf) {
        return MediaType.APPLICATION_UNKNOWN;
    }

    default public MediaType readValueType(ByteBuf buf) {
        return MediaType.APPLICATION_UNKNOWN;
    }

    public boolean isObjectStorageHinted(PingResponse var1);

    public int estimateSizeMultimapSupportsDuplicated();

    public void writeMultimapSupportDuplicates(ByteBuf var1, boolean var2);
}

