/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.event.impl;

import java.util.concurrent.ScheduledFuture;
import java.util.function.Consumer;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.event.impl.EventDispatcher;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;

public class ReconnectTask
implements Runnable,
Consumer<Void> {
    private static final Log log = LogFactory.getLog(ReconnectTask.class);
    private final EventDispatcher<?> dispatcher;
    private ScheduledFuture<?> cancellationFuture;
    private boolean completed = false;

    public ReconnectTask(EventDispatcher<?> dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public void run() {
        if (log.isTraceEnabled()) {
            log.tracef("Reconnecting client listener with id %s", Util.printArray((byte[])this.dispatcher.listenerId));
        }
        this.dispatcher.executeFailover().thenAccept((Consumer)this);
    }

    public synchronized void setCancellationFuture(ScheduledFuture<?> cancellationFuture) {
        this.cancellationFuture = cancellationFuture;
        if (this.completed) {
            cancellationFuture.cancel(false);
        }
    }

    @Override
    public synchronized void accept(Void address) {
        ScheduledFuture<?> cancellationFuture = this.cancellationFuture;
        this.completed = true;
        if (cancellationFuture != null) {
            cancellationFuture.cancel(false);
        }
    }
}

