/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transaction;

import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.function.Function;
import org.infinispan.commons.time.TimeService;
import org.infinispan.hotrod.impl.HotRodTransport;
import org.infinispan.hotrod.impl.cache.RemoteCacheImpl;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.transaction.TransactionContext;
import org.infinispan.hotrod.impl.transaction.TransactionTable;

public class TransactionalRemoteCacheImpl<K, V>
extends RemoteCacheImpl<K, V> {
    private static final Log log = LogFactory.getLog(TransactionalRemoteCacheImpl.class, Log.class);
    private final boolean recoveryEnabled;
    private final TransactionManager transactionManager;
    private final TransactionTable transactionTable;
    private final Function<K, byte[]> keyMarshaller = this::keyToBytes;
    private final Function<V, byte[]> valueMarshaller = this::valueToBytes;

    public TransactionalRemoteCacheImpl(HotRodTransport hotRodTransport, String name, boolean recoveryEnabled, TransactionManager transactionManager, TransactionTable transactionTable, TimeService timeService) {
        super(hotRodTransport, name, timeService, null);
        this.recoveryEnabled = recoveryEnabled;
        this.transactionManager = transactionManager;
        this.transactionTable = transactionTable;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    boolean isRecoveryEnabled() {
        return this.recoveryEnabled;
    }

    Function<K, byte[]> keyMarshaller() {
        return this.keyMarshaller;
    }

    Function<V, byte[]> valueMarshaller() {
        return this.valueMarshaller;
    }

    private TransactionContext<K, V> getTransactionContext() {
        this.assertRemoteCacheManagerIsStarted();
        Transaction tx = this.getRunningTransaction();
        if (tx != null) {
            return this.transactionTable.enlist(this, tx);
        }
        return null;
    }

    private Transaction getRunningTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            log.debug("Exception in getRunningTransaction().", e);
            return null;
        }
    }
}

