/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod;

import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryMetadata;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.test.KeyValueGenerator;
import org.junit.jupiter.api.Assertions;

public final class CacheEntryAssertions {
    private CacheEntryAssertions() {
    }

    public static <K, V> void assertEntry(K key, V value, KeyValueGenerator<K, V> kv, CacheEntry<K, V> entry) {
        kv.assertKeyEquals(key, entry.key());
        kv.assertValueEquals(value, entry.value());
        CacheEntryMetadata metadata = entry.metadata();
        if (metadata != null) {
            Assertions.assertNotNull((Object)metadata.version());
        }
    }

    public static <K, V> void assertEntry(K key, V value, KeyValueGenerator<K, V> kv, CacheEntry<K, V> entry, CacheWriteOptions writeOptions) {
        CacheEntryAssertions.assertEntry(key, value, kv, entry);
        CacheEntryMetadata metadata = entry.metadata();
        Assertions.assertEquals((Object)writeOptions.expiration(), (Object)metadata.expiration());
    }
}

