/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Set;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.VersionedOperationResponse;
import org.infinispan.hotrod.impl.cache.CacheEntryImpl;
import org.infinispan.hotrod.impl.cache.CacheEntryMetadataImpl;
import org.infinispan.hotrod.impl.cache.CacheEntryVersionImpl;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.StatsAffectingRetryingOperation;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;

public abstract class AbstractKeyOperation<K, T>
extends StatsAffectingRetryingOperation<T> {
    protected final K key;
    protected final byte[] keyBytes;

    protected AbstractKeyOperation(OperationContext operationContext, short requestCode, short responseCode, K key, byte[] keyBytes, CacheOptions options, DataFormat dataFormat) {
        super(operationContext, requestCode, responseCode, options, dataFormat);
        this.key = key;
        this.keyBytes = keyBytes;
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (retryCount == 0) {
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(this.key == null ? this.keyBytes : (byte[])this.key, failedServers, this.operationContext.getCacheNameBytes(), this);
        } else {
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(failedServers, this.operationContext.getCacheNameBytes(), this);
        }
    }

    protected <V> CacheEntry<K, V> returnPossiblePrevValue(ByteBuf buf, short status) {
        return this.operationContext.getCodec().returnPossiblePrevValue(this.operationKey(), buf, status, this.dataFormat(), this.flags(), this.operationContext.getConfiguration().getClassAllowList(), this.operationContext.getChannelFactory().getMarshaller());
    }

    public K operationKey() {
        if (this.key == null) {
            return (K)this.dataFormat().keyToObj(this.keyBytes, this.operationContext.getConfiguration().getClassAllowList());
        }
        return this.key;
    }

    protected <V> VersionedOperationResponse<CacheEntry<K, V>> returnVersionedOperationResponse(ByteBuf buf, short status) {
        VersionedOperationResponse.RspCode code;
        if (HotRodConstants.isSuccess(status)) {
            code = VersionedOperationResponse.RspCode.SUCCESS;
        } else if (HotRodConstants.isNotExecuted(status)) {
            code = VersionedOperationResponse.RspCode.MODIFIED_KEY;
        } else if (HotRodConstants.isNotExist(status)) {
            code = VersionedOperationResponse.RspCode.NO_SUCH_KEY;
        } else {
            throw new IllegalStateException("Unknown response status: " + Integer.toHexString(status));
        }
        CacheEntry<K, V> prevValue = this.returnPossiblePrevValue(buf, status);
        return new VersionedOperationResponse<CacheEntry<K, V>>(prevValue, code);
    }

    @Override
    protected void addParams(StringBuilder sb) {
        sb.append(", key=").append((Object)(this.key == null ? Util.printArray((byte[])this.keyBytes) : this.key));
    }

    public static <K, V> CacheEntry<K, V> readEntry(ByteBuf buf, K key, DataFormat dataFormat, ClassAllowList allowList) {
        short flags = buf.readUnsignedByte();
        long creation = -1L;
        int lifespan = -1;
        long lastUsed = -1L;
        int maxIdle = -1;
        if ((flags & 1) != 1) {
            creation = buf.readLong();
            lifespan = ByteBufUtil.readVInt(buf);
        }
        if ((flags & 2) != 2) {
            lastUsed = buf.readLong();
            maxIdle = ByteBufUtil.readVInt(buf);
        }
        CacheEntryExpiration expiration = lifespan < 0 ? (maxIdle < 0 ? CacheEntryExpiration.IMMORTAL : CacheEntryExpiration.withMaxIdle((Duration)Duration.ofSeconds(maxIdle))) : (maxIdle < 0 ? CacheEntryExpiration.withLifespan((Duration)Duration.ofSeconds(lifespan)) : CacheEntryExpiration.withLifespanAndMaxIdle((Duration)Duration.ofSeconds(lifespan), (Duration)Duration.ofSeconds(maxIdle)));
        CacheEntryVersionImpl version = new CacheEntryVersionImpl(buf.readLong());
        if (log.isTraceEnabled()) {
            log.tracef("Received version: %s", version);
        }
        Object value = dataFormat.valueToObj(ByteBufUtil.readArray(buf), allowList);
        return new CacheEntryImpl(key, value, new CacheEntryMetadataImpl(creation, lastUsed, expiration, version));
    }
}

