/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod;

import java.lang.reflect.Method;
import java.net.URI;
import org.infinispan.api.Infinispan;
import org.infinispan.api.configuration.Configuration;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.hotrod.HotRod;
import org.infinispan.hotrod.configuration.HotRodConfiguration;
import org.infinispan.hotrod.configuration.HotRodConfigurationBuilder;
import org.infinispan.hotrod.impl.HotRodURI;
import org.infinispan.hotrod.impl.transport.netty.HotRodTestTransport;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class HotRodServerExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback {
    private HotRodServer hotRodServer;
    private String cacheName;

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.stop();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.start();
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Method method = (Method)extensionContext.getTestMethod().orElseThrow();
        this.cacheName = method.getName();
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).transaction().cacheStopTimeout(0L);
        this.hotRodServer.getCacheManager().createCache(this.cacheName, builder.build());
    }

    public void start() {
        if (this.hotRodServer == null) {
            TestResourceTracker.setThreadTestName((String)"InfinispanServer");
            GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
            ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
            gcb.transport().defaultTransport();
            gcb.defaultCacheName("default");
            EmbeddedCacheManager ecm = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)gcb, (ConfigurationBuilder)new ConfigurationBuilder(), (TransportFlags)new TransportFlags());
            ecm.administration().createTemplate("test", new ConfigurationBuilder().template(true).build());
            HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
            serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
            this.hotRodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)ecm, (HotRodServerConfigurationBuilder)serverBuilder);
        }
    }

    public void stop() {
        if (this.hotRodServer != null) {
            EmbeddedCacheManager cacheManager = this.hotRodServer.getCacheManager();
            this.hotRodServer.stop();
            cacheManager.stop();
            this.hotRodServer = null;
        }
    }

    public String cacheName() {
        return this.cacheName;
    }

    public Infinispan getClient() {
        HotRodConfigurationBuilder builder = new HotRodConfigurationBuilder();
        builder.addServer().host(this.hotRodServer.getHost()).port(this.hotRodServer.getPort().intValue());
        return Infinispan.create((Configuration)builder.build(), (Infinispan.Factory)new Infinispan.Factory(){

            public Infinispan create(URI uri) {
                try {
                    return this.create((Configuration)HotRodURI.create((URI)uri).toConfigurationBuilder().build());
                }
                catch (Throwable t) {
                    return null;
                }
            }

            public Infinispan create(Configuration configuration) {
                assert (configuration instanceof HotRodConfiguration);
                HotRodConfiguration hrc = (HotRodConfiguration)configuration;
                return new HotRod(hrc, HotRodTestTransport.createTestTransport(hrc));
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public HotRodServerExtension build() {
            return new HotRodServerExtension();
        }
    }
}

