/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.util.concurrent.Executor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.lucene.directory.BuildContext;
import org.infinispan.lucene.impl.BaseLockFactory;
import org.infinispan.lucene.impl.DirectoryLucene;
import org.infinispan.lucene.logging.Log;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.LogFactory;

public class DirectoryBuilderImpl
implements BuildContext {
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private static final Log log = (Log)LogFactory.getLog(DirectoryBuilderImpl.class, Log.class);
    private final Cache<?, ?> metadataCache;
    private final Cache<?, ?> chunksCache;
    private final Cache<?, ?> distLocksCache;
    private final String indexName;
    private int chunkSize = 0x100000;
    private SegmentReadLocker srl = null;
    private LockFactory lockFactory = null;
    private boolean writeFileListAsync = false;
    private Executor deleteExecutor = null;
    private int affinitySegmentId = -1;

    public DirectoryBuilderImpl(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, Cache<?, ?> distLocksCache, String indexName) {
        this.metadataCache = DirectoryBuilderImpl.checkValidConfiguration(DirectoryBuilderImpl.checkNotNull(metadataCache, "metadataCache"), indexName);
        this.chunksCache = DirectoryBuilderImpl.checkValidConfiguration(DirectoryBuilderImpl.checkNotNull(chunksCache, "chunksCache"), indexName);
        this.distLocksCache = DirectoryBuilderImpl.checkValidConfiguration(DirectoryBuilderImpl.checkNotNull(distLocksCache, "distLocksCache"), indexName);
        this.indexName = DirectoryBuilderImpl.checkNotNull(indexName, "indexName");
        DirectoryBuilderImpl.validateMetadataCache(metadataCache, indexName);
    }

    @Override
    public Directory create() {
        if (this.lockFactory == null) {
            this.lockFactory = DirectoryBuilderImpl.makeDefaultLockFactory();
        }
        if (this.srl == null) {
            this.srl = DirectoryBuilderImpl.makeDefaultSegmentReadLocker(this.metadataCache, this.chunksCache, this.distLocksCache, this.indexName, this.affinitySegmentId);
        }
        if (this.deleteExecutor == null) {
            this.deleteExecutor = new WithinThreadExecutor();
        }
        return new DirectoryLucene(this.metadataCache, this.chunksCache, this.distLocksCache, this.indexName, this.lockFactory, this.chunkSize, this.srl, this.writeFileListAsync, this.deleteExecutor, this.affinitySegmentId);
    }

    @Override
    public BuildContext chunkSize(int bytes) {
        if (bytes <= 0) {
            throw new IllegalArgumentException("chunkSize must be a positive integer");
        }
        this.chunkSize = bytes;
        return this;
    }

    @Override
    public BuildContext overrideSegmentReadLocker(SegmentReadLocker srl) {
        DirectoryBuilderImpl.checkNotNull(srl, "srl");
        this.srl = srl;
        return this;
    }

    @Override
    public BuildContext affinityLocationIntoSegment(int segmentId) {
        if (segmentId < 0) {
            throw log.affinityLocationIntoSegmentValueShallNotBeNegative(this.indexName, segmentId);
        }
        this.affinitySegmentId = segmentId;
        return this;
    }

    @Override
    public BuildContext writeFileListAsynchronously(boolean writeFileListAsync) {
        this.writeFileListAsync = writeFileListAsync;
        return this;
    }

    @Override
    public BuildContext deleteOperationsExecutor(Executor executor) {
        DirectoryBuilderImpl.checkNotNull(executor, "executor");
        this.deleteExecutor = executor;
        return this;
    }

    @Override
    public BuildContext overrideWriteLocker(LockFactory lockFactory) {
        DirectoryBuilderImpl.checkNotNull(lockFactory, "lockFactory");
        this.lockFactory = lockFactory;
        return this;
    }

    private static SegmentReadLocker makeDefaultSegmentReadLocker(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, Cache<?, ?> distLocksCache, String indexName, int affinitySegmentId) {
        DirectoryBuilderImpl.checkNotNull(distLocksCache, "distLocksCache");
        DirectoryBuilderImpl.checkNotNull(indexName, "indexName");
        return new DistributedSegmentReadLocker(distLocksCache, chunksCache, metadataCache, indexName, affinitySegmentId);
    }

    private static <T> T checkNotNull(T v, String objectname) {
        if (v == null) {
            throw log.requiredParameterWasPassedNull(objectname);
        }
        return v;
    }

    private static Cache<?, ?> checkValidConfiguration(Cache<?, ?> cache, String indexName) {
        Configuration configuration = cache.getCacheConfiguration();
        if (configuration.expiration().maxIdle() != -1L) {
            throw log.luceneStorageHavingIdleTimeSet(indexName, cache.getName());
        }
        if (configuration.expiration().lifespan() != -1L) {
            throw log.luceneStorageHavingLifespanSet(indexName, cache.getName());
        }
        if (configuration.memory().storageType() == StorageType.BINARY) {
            throw log.luceneStorageAsBinaryEnabled(indexName, cache.getName());
        }
        if (!Configurations.noDataLossOnJoiner((Configuration)configuration)) {
            throw log.luceneStorageNoStateTransferEnabled(indexName, cache.getName());
        }
        return cache;
    }

    private static LockFactory makeDefaultLockFactory() {
        return BaseLockFactory.INSTANCE;
    }

    private static void validateMetadataCache(Cache<?, ?> cache, String indexName) {
        Configuration configuration = cache.getCacheConfiguration();
        if (configuration.memory().isEvictionEnabled()) {
            throw log.evictionNotAllowedInMetadataCache(indexName, cache.getName());
        }
        if (configuration.persistence().usingStores() && !configuration.persistence().preload().booleanValue()) {
            throw log.preloadNeededIfPersistenceIsEnabledForMetadataCache(indexName, cache.getName());
        }
    }
}

