/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshaller.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.io.ExposedByteArrayOutputStream;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.marshaller.kryo.SerializerRegistryService;

public class KryoMarshaller
extends AbstractMarshaller {
    private static final List<SerializerRegistryService> serializerServices = new ArrayList<SerializerRegistryService>();
    private final Kryo kryo = new Kryo();

    public KryoMarshaller() {
        serializerServices.forEach(service -> service.register(this.kryo));
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public void registerSerializer(Class type, Serializer serializer) {
        this.kryo.register(type, serializer);
    }

    public Object objectFromByteBuffer(byte[] bytes, int offset, int length) {
        try (Input input = new Input(bytes, offset, length);){
            Object object = this.kryo.readClassAndObject(input);
            return object;
        }
    }

    protected ByteBuffer objectToBuffer(Object obj, int estimatedSize) {
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            return new ByteBufferImpl(bytes, 0, bytes.length);
        }
        try (Output output = new Output((OutputStream)new ExposedByteArrayOutputStream(estimatedSize), estimatedSize);){
            this.kryo.writeClassAndObject(output, obj);
            byte[] bytes = output.toBytes();
            ByteBufferImpl byteBufferImpl = new ByteBufferImpl(bytes, 0, bytes.length);
            return byteBufferImpl;
        }
    }

    public boolean isMarshallable(Object obj) throws Exception {
        try {
            this.objectToBuffer(obj);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        ServiceLoader.load(SerializerRegistryService.class, KryoMarshaller.class.getClassLoader()).forEach(serializerServices::add);
    }
}

