/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshaller.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.io.ExposedByteArrayOutputStream;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.marshaller.kryo.SerializerRegistryService;

public class KryoMarshaller
extends AbstractMarshaller {
    private static final List<SerializerRegistryService> serializerServices = new ArrayList<SerializerRegistryService>();
    private final KryoPool pool;

    public KryoMarshaller() {
        KryoFactory factory = () -> {
            Kryo kryo = new Kryo();
            serializerServices.forEach(service -> service.register(kryo));
            return kryo;
        };
        this.pool = new KryoPool.Builder(factory).softReferences().build();
    }

    public Object objectFromByteBuffer(byte[] bytes, int offset, int length) {
        return this.pool.run(kryo -> {
            try (Input input = new Input(bytes, offset, length);){
                Object object = kryo.readClassAndObject(input);
                return object;
            }
        });
    }

    protected ByteBuffer objectToBuffer(Object obj, int estimatedSize) {
        return (ByteBuffer)this.pool.run(kryo -> {
            try (Output output = new Output((OutputStream)new ExposedByteArrayOutputStream(estimatedSize), estimatedSize);){
                kryo.writeClassAndObject(output, obj);
                byte[] bytes = output.toBytes();
                ByteBufferImpl byteBufferImpl = new ByteBufferImpl(bytes, 0, bytes.length);
                return byteBufferImpl;
            }
        });
    }

    public boolean isMarshallable(Object obj) throws Exception {
        try {
            this.objectToBuffer(obj);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        ServiceLoader.load(SerializerRegistryService.class, KryoMarshaller.class.getClassLoader()).forEach(serializerServices::add);
    }
}

