/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.osgi;

import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

@Deprecated
public class InfinispanEmbeddedServiceFactory
implements ManagedServiceFactory {
    private static final String PROP_CONFIG = "config";
    private static final String PROP_INSTANCE_ID = "instanceId";
    private BundleContext bundleContext;
    private Map<String, DefaultCacheManager> cacheManagers = new HashMap<String, DefaultCacheManager>();
    private Map<String, ServiceRegistration<EmbeddedCacheManager>> managedRegistrations = new HashMap<String, ServiceRegistration<EmbeddedCacheManager>>();

    public String getName() {
        return "Infinispan Embedded Managed Service Factory";
    }

    public synchronized void updated(String pid, Dictionary properties) throws ConfigurationException {
        String config = (String)properties.get(PROP_CONFIG);
        if (config == null) {
            throw new ConfigurationException(PROP_CONFIG, "Property must be set");
        }
        String instanceId = (String)properties.get(PROP_INSTANCE_ID);
        if (instanceId == null) {
            throw new ConfigurationException(PROP_INSTANCE_ID, "Property must be set");
        }
        try {
            URL configURL = FileLookupFactory.newInstance().lookupFileLocation(config, Thread.currentThread().getContextClassLoader());
            if (configURL == null) {
                throw new ConfigurationException(PROP_CONFIG, String.format("Failed to find the specified config '%s'.", config));
            }
            this.deleted(pid);
            InputStream configStream = configURL.openStream();
            DefaultCacheManager cacheManager = new DefaultCacheManager(configStream);
            cacheManager.start();
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put(PROP_INSTANCE_ID, instanceId);
            ht.put(PROP_CONFIG, config);
            ServiceRegistration serviceRegistration = this.bundleContext.registerService(EmbeddedCacheManager.class, (Object)cacheManager, ht);
            this.managedRegistrations.put(pid, (ServiceRegistration<EmbeddedCacheManager>)serviceRegistration);
            this.cacheManagers.put(pid, cacheManager);
        }
        catch (Exception e) {
            throw new ConfigurationException(null, "Cannot start the CacheManager", (Throwable)e);
        }
    }

    public synchronized void deleted(String pid) {
        DefaultCacheManager cacheManager;
        ServiceRegistration<EmbeddedCacheManager> serviceRegistration = this.managedRegistrations.remove(pid);
        if (serviceRegistration != null) {
            try {
                serviceRegistration.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((cacheManager = this.cacheManagers.remove(pid)) != null) {
            try {
                cacheManager.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void destroy() {
        HashSet<String> keys = new HashSet<String>(this.cacheManagers.keySet());
        for (String cacheManager : keys) {
            this.deleted(cacheManager);
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

