/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.api;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.api.TestEntity;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.api.ReplaceTest")
public class ReplaceTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addIndexedEntity(TestEntity.class).addProperty("default.directory_provider", "ram").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplaceSimple() {
        EmbeddedCacheManager simpleCacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(true));
        try {
            Cache simpleCache = simpleCacheManager.getCache();
            TestEntity se1 = new TestEntity("name1", "surname1", 10L, "note");
            TestEntity se2 = new TestEntity("name2", "surname2", 10L, "note");
            simpleCache.put((Object)se1.getId(), (Object)se1);
            TestEntity se1ret = (TestEntity)simpleCache.replace((Object)se2.getId(), (Object)se2);
            Assert.assertEquals((Object)se1, (Object)se1ret);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{simpleCacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{simpleCacheManager});
    }

    public void testReplaceSimpleSearchable() {
        TestEntity se1 = new TestEntity("name1", "surname1", 10L, "note");
        TestEntity se2 = new TestEntity("name2", "surname2", 10L, "note");
        this.cache.put((Object)se1.getId(), (Object)se1);
        TestEntity se1ret = (TestEntity)this.cache.replace((Object)se2.getId(), (Object)se2);
        Assert.assertEquals((Object)se1, (Object)se1ret);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testReplaceSimpleSearchableConditional() {
        TestEntity se1 = new TestEntity("name1", "surname1", 10L, "note");
        TestEntity se2 = new TestEntity("name2", "surname2", 10L, "note");
        this.cache.put((Object)se1.getId(), (Object)se1);
        assert (this.cache.replace((Object)se2.getId(), (Object)se1, (Object)se2));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }
}

