/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.classloading;

import java.util.List;
import org.apache.lucene.search.Query;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.classloading.CountingClassLoader;
import org.infinispan.query.indexedembedded.Book;
import org.infinispan.query.test.CustomKey;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.classloading.KeyTransformationUsingClassloadersTest")
public class KeyTransformationUsingClassloadersTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addIndexedEntity(Book.class).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @Test
    public void searchWithCustomClassLoader() {
        this.cache.put((Object)new CustomKey(1, 2, 3), (Object)new Book("Seam in Action", "Dan Allen", "Manning"));
        this.cache.put((Object)new CustomKey(4, 5, 6), (Object)new Book("Hibernate Search in Action", "Emmanuel Bernard and John Griffin", "Manning"));
        this.cache.put((Object)"simple-3", (Object)new Book("Megaprogramming Ruby", "Paolo Perrotta", "The Pragmatic Programmers"));
        CountingClassLoader classLoader = new CountingClassLoader();
        AdvancedCache applicationCache = this.cache.getAdvancedCache().with((ClassLoader)classLoader);
        SearchManager qf = Search.getSearchManager((Cache)applicationCache);
        assert (classLoader.countInvocations.get() == 0);
        Query query = qf.buildQueryBuilderForClass(Book.class).get().phrase().onField("title").sentence("in action").createQuery();
        List list = qf.getQuery(query, new Class[0]).list();
        assert (list.size() == 2);
        int invocationsCount = classLoader.countInvocations.get();
        assert (invocationsCount >= 1) : "Received instead " + invocationsCount + " invocations";
    }
}

