/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import javax.transaction.TransactionManager;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.helper.TestableCluster;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.MultiNodeDistributedTest")
public class MultiNodeDistributedTest
extends AbstractInfinispanTest {
    protected final TestableCluster<String, Person> cluster = new TestableCluster(this.getConfigurationResourceName());

    protected String getConfigurationResourceName() {
        return "dynamic-indexing-distribution.xml";
    }

    protected void storeOn(Cache<String, Person> cache, String key, Person person) throws Exception {
        TransactionManager transactionManager = cache.getAdvancedCache().getTransactionManager();
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        cache.put((Object)key, (Object)person);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
    }

    public void testIndexingWorkDistribution() throws Exception {
        try {
            this.cluster.startNewNode();
            this.cluster.startNewNode();
            this.assertIndexSize(0);
            this.storeOn(this.cluster.getCache(0), "k1", new Person("K. Firt", "Is not a character from the matrix", 1));
            this.assertIndexSize(1);
            this.storeOn(this.cluster.getCache(1), "k2", new Person("K. Seycond", "Is a pilot", 1));
            this.assertIndexSize(2);
            this.storeOn(this.cluster.getCache(0), "k3", new Person("K. Theerd", "Forgot the fundamental laws", 1));
            this.assertIndexSize(3);
            this.storeOn(this.cluster.getCache(1), "k3", new Person("K. Overide", "Impersonating Mr. Theerd", 1));
            this.assertIndexSize(3);
            this.cluster.startNewNode();
            this.storeOn(this.cluster.getCache(2), "k4", new Person("K. Forth", "Dynamic Topology!", 1));
            this.assertIndexSize(4);
            this.cluster.startNewNode();
            this.assertIndexSize(4);
            this.killMasterNode();
            this.storeOn(this.cluster.getCache(2), "k5", new Person("K. Vife", "Gets stuck in a buffer", 1));
            this.storeOn(this.cluster.getCache(2), "k6", new Person("K. Seix", "Fills the buffer", 1));
            this.storeOn(this.cluster.getCache(2), "k7", new Person("K. Vife", "Failover!", 1));
            this.assertIndexSize(7);
        }
        finally {
            this.cluster.killAll();
        }
    }

    protected void killMasterNode() {
        for (Cache<String, Person> cache : this.cluster.iterateAllCaches()) {
            if (!this.isMasterNode(cache)) continue;
            this.cluster.killNode(cache);
            break;
        }
    }

    private boolean isMasterNode(Cache<?, ?> cache) {
        SearchManager searchManager = Search.getSearchManager(cache);
        SearchIntegrator searchFactory = (SearchIntegrator)searchManager.unwrap(SearchIntegrator.class);
        InfinispanIndexManager indexManager = (InfinispanIndexManager)searchFactory.getIndexManager("person");
        return indexManager.isMasterLocal();
    }

    protected void assertIndexSize(int expectedIndexSize) {
        for (Cache<String, Person> cache : this.cluster.iterateAllCaches()) {
            StaticTestingErrorHandler.assertAllGood(cache);
            SearchManager searchManager = Search.getSearchManager(cache);
            CacheQuery query = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{Person.class});
            Assert.assertEquals((long)expectedIndexSize, (long)query.list().size());
        }
    }

    protected boolean transactionsEnabled() {
        return false;
    }
}

