/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.performance;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"performance"}, testName="query.performance.LoopingWriterTest")
public class LoopingWriterTest
extends AbstractInfinispanTest {
    private static final int TOTAL_LOOPS = Integer.MAX_VALUE;
    private static final int TIMESAMPLE_PERIODICITY = 6000;
    private static final int QUERY_PERIODICITY = 15170;

    public void neverEndingWrite() throws IOException {
        EmbeddedCacheManager embeddedCacheManager = TestCacheManagerFactory.fromXml((String)"nrt-performance-writer-infinispandirectory.xml");
        try {
            Cache cache = embeddedCacheManager.getCache("Indexed");
            cache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
            this.writeStuff((Cache<Object, Object>)cache);
        }
        finally {
            embeddedCacheManager.stop();
        }
    }

    private void writeStuff(Cache<Object, Object> cache) {
        long startTime = System.nanoTime();
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String key = "K" + i;
            Person value = new Person(key, key, i);
            cache.put((Object)key, (Object)value);
            if (i % 15170 == 0) {
                this.countElementsViaQuery(cache, i);
            }
            if (i % 6000 != 0) continue;
            long currentTimeStamp = System.nanoTime();
            long elapsed = currentTimeStamp - startTime;
            double elementsWrittenPerSecond = (double)TimeUnit.NANOSECONDS.convert(i, TimeUnit.SECONDS) / (double)elapsed;
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(2);
            nf.setGroupingUsed(true);
            System.out.println("Transactions committed to index per second: " + nf.format(elementsWrittenPerSecond) + ". Total documents: " + i + " Total time: " + Util.prettyPrintTime((long)elapsed, (TimeUnit)TimeUnit.NANOSECONDS));
        }
    }

    private void countElementsViaQuery(Cache<Object, Object> cache, int expectedElements) {
        SearchManager searchManager = Search.getSearchManager(cache);
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        int resultSize = searchManager.getQuery((Query)query, new Class[0]).getResultSize();
        Assert.assertEquals((int)resultSize, (int)expectedElements);
        System.out.println("Query OK! found (as expected) " + resultSize + " elements");
    }

    @Test(enabled=false)
    public static void main(String[] args) throws IOException {
        LoopingWriterTest runner = new LoopingWriterTest();
        runner.neverEndingWrite();
    }
}

