/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.tx;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.exception.SearchException;
import org.infinispan.Cache;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.tx.TwoPhaseCommitIndexingTest")
public class TwoPhaseCommitIndexingTest
extends SingleCacheManagerTest {
    private final AtomicBoolean injectFailures = new AtomicBoolean();
    private final BlowUpInterceptor nastyInterceptor = new BlowUpInterceptor(this.injectFailures);

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.customInterceptors().addInterceptor().after(EntryWrappingInterceptor.class).interceptor((CommandInterceptor)this.nastyInterceptor).transaction().transactionMode(TransactionMode.TRANSACTIONAL).use1PcForAutoCommitTransactions(false).indexing().index(Index.ALL).addIndexedEntity(Person.class).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testQueryAfterAddingNewNode() throws Exception {
        this.store("Astronaut", new Person("Astronaut", "is asking his timezone", 32), true);
        this.assertFind("timezone", 0);
        this.assertFind("asking", 0);
        this.assertFind("cat", 0);
        this.store("Astronaut", new Person("Astronaut", "is asking his timezone", 32), false);
        this.assertFind("timezone", 1);
        this.assertFind("asking", 1);
        this.assertFind("cat", 0);
    }

    private void assertFind(String keyword, int expectedCount) {
        TwoPhaseCommitIndexingTest.assertFind(this.cache, keyword, expectedCount);
    }

    private static void assertFind(Cache cache, String keyword, int expectedCount) {
        SearchManager queryFactory = Search.getSearchManager((Cache)cache);
        TermQuery luceneQuery = new TermQuery(new Term("blurb", keyword));
        CacheQuery cacheQuery = queryFactory.getQuery((Query)luceneQuery, new Class[]{Person.class});
        int resultSize = cacheQuery.getResultSize();
        Assert.assertEquals((int)resultSize, (int)expectedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(String key, Object value, boolean failTheOperation) {
        if (failTheOperation) {
            this.injectFailures.set(true);
            try {
                this.cache.put((Object)key, value);
                Assert.fail((String)"Should have failed the implicit transaction");
            }
            catch (Exception exception) {
            }
            finally {
                this.injectFailures.set(false);
            }
        } else {
            this.cache.put((Object)key, value);
        }
    }

    private static class BlowUpInterceptor
    extends CommandInterceptor {
        private final AtomicBoolean injectFailures;

        public BlowUpInterceptor(AtomicBoolean injectFailures) {
            this.injectFailures = injectFailures;
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            if (this.injectFailures.get()) {
                throw new SearchException("Test");
            }
            return super.visitPrepareCommand(ctx, command);
        }
    }
}

