/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.impl.BaseQuery;

final class EmbeddedLuceneQuery<TypeMetadata>
extends BaseQuery {
    private final QueryEngine<TypeMetadata> queryEngine;
    private final QueryEngine.RowProcessor rowProcessor;
    private final IckleParsingResult<TypeMetadata> parsingResult;
    private CacheQuery<?> cacheQuery;
    private List<?> results;
    private final IndexedQueryMode queryMode;

    EmbeddedLuceneQuery(QueryEngine<TypeMetadata> queryEngine, QueryFactory queryFactory, Map<String, Object> namedParameters, IckleParsingResult<TypeMetadata> parsingResult, String[] projection, QueryEngine.RowProcessor rowProcessor, long startOffset, int maxResults, IndexedQueryMode queryMode) {
        super(queryFactory, parsingResult.getQueryString(), namedParameters, projection, startOffset, maxResults);
        if (rowProcessor != null && (projection == null || projection.length == 0)) {
            throw new IllegalArgumentException("A RowProcessor can only be specified with projections");
        }
        this.queryEngine = queryEngine;
        this.queryMode = queryMode;
        this.rowProcessor = rowProcessor;
        this.parsingResult = parsingResult;
    }

    public void resetQuery() {
        this.results = null;
        this.cacheQuery = null;
    }

    private CacheQuery<?> createCacheQuery() {
        if (this.cacheQuery == null) {
            this.validateNamedParameters();
            this.cacheQuery = this.queryEngine.buildLuceneQuery(this.parsingResult, this.namedParameters, this.startOffset, this.maxResults, this.queryMode);
        }
        return this.cacheQuery;
    }

    public <T> List<T> list() {
        if (this.results == null) {
            List list = this.createCacheQuery().list();
            this.results = this.rowProcessor == null ? list : (List)list.stream().map(this.rowProcessor).collect(Collectors.toCollection(() -> new ArrayList(list.size())));
        }
        return this.results;
    }

    public int getResultSize() {
        return this.createCacheQuery().getResultSize();
    }

    public String toString() {
        return "EmbeddedLuceneQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + '}';
    }
}

