/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.infinispan.commons.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

public class OsgiClassLoader
extends ClassLoader {
    private final List<WeakReference<Bundle>> bundles;
    private final Map<String, Class<?>> classCache = new HashMap();
    private final Map<String, URL> resourceCache = new HashMap<String, URL>();
    private static OsgiClassLoader instance = null;

    public static OsgiClassLoader getInstance() {
        if (instance == null) {
            instance = new OsgiClassLoader();
        }
        return instance;
    }

    private OsgiClassLoader() {
        super(null);
        if (Util.isOSGiContext()) {
            BundleContext bundleContext = ((BundleReference)OsgiClassLoader.class.getClassLoader()).getBundle().getBundleContext();
            Bundle[] foundBundles = bundleContext.getBundles();
            this.bundles = new ArrayList<WeakReference<Bundle>>(foundBundles.length);
            for (Bundle foundBundle : foundBundles) {
                this.bundles.add(new WeakReference<Bundle>(foundBundle));
            }
        } else {
            this.bundles = Collections.EMPTY_LIST;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.classCache.containsKey(name)) {
            return this.classCache.get(name);
        }
        for (WeakReference<Bundle> ref : this.bundles) {
            Bundle bundle = (Bundle)ref.get();
            if (bundle == null || bundle.getState() != 32) continue;
            try {
                Class clazz = bundle.loadClass(name);
                if (clazz == null) continue;
                this.classCache.put(name, clazz);
                return clazz;
            }
            catch (Exception ignore) {
            }
        }
        throw new ClassNotFoundException("Could not load requested class : " + name);
    }

    @Override
    protected URL findResource(String name) {
        if (this.resourceCache.containsKey(name)) {
            return this.resourceCache.get(name);
        }
        for (WeakReference<Bundle> ref : this.bundles) {
            Bundle bundle = (Bundle)ref.get();
            if (bundle.getState() != 32) continue;
            try {
                URL resource = bundle.getResource(name);
                if (resource == null) continue;
                this.resourceCache.put(name, resource);
                return resource;
            }
            catch (Exception ignore) {
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        final ArrayList<Enumeration> enumerations = new ArrayList<Enumeration>();
        for (WeakReference<Bundle> ref : this.bundles) {
            Bundle bundle = (Bundle)ref.get();
            if (bundle.getState() != 32) continue;
            try {
                Enumeration resources = bundle.getResources(name);
                if (resources == null) continue;
                enumerations.add(resources);
            }
            catch (Exception ignore) {}
        }
        Enumeration<URL> aggEnumeration = new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                for (Enumeration enumeration : enumerations) {
                    if (enumeration == null || !enumeration.hasMoreElements()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                for (Enumeration enumeration : enumerations) {
                    if (enumeration == null || !enumeration.hasMoreElements()) continue;
                    return (URL)enumeration.nextElement();
                }
                throw new NoSuchElementException();
            }
        };
        return aggEnumeration;
    }
}

