/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.Message;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ProtoStreamReaderImpl;
import org.infinispan.protostream.impl.ProtoStreamWriterImpl;
import org.infinispan.protostream.impl.ReadMessageContext;
import org.infinispan.protostream.impl.WireFormat;
import org.infinispan.protostream.impl.WriteMessageContext;

public final class MessageMarshallerDelegate<T>
implements BaseMarshallerDelegate<T> {
    private final MessageMarshaller<T> marshaller;
    private final Descriptor messageDescriptor;
    private final FieldDescriptor[] fieldDescriptors;
    private final Map<String, FieldDescriptor> fieldsByName;

    public MessageMarshallerDelegate(MessageMarshaller<T> marshaller, Descriptor messageDescriptor) {
        this.marshaller = marshaller;
        this.messageDescriptor = messageDescriptor;
        List<FieldDescriptor> fields = messageDescriptor.getFields();
        this.fieldDescriptors = fields.toArray(new FieldDescriptor[fields.size()]);
        this.fieldsByName = new HashMap<String, FieldDescriptor>(this.fieldDescriptors.length);
        for (FieldDescriptor fd : this.fieldDescriptors) {
            this.fieldsByName.put(fd.getName(), fd);
        }
    }

    @Override
    public MessageMarshaller<T> getMarshaller() {
        return this.marshaller;
    }

    public Descriptor getMessageDescriptor() {
        return this.messageDescriptor;
    }

    public FieldDescriptor[] getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public Map<String, FieldDescriptor> getFieldsByName() {
        return this.fieldsByName;
    }

    @Override
    public void marshall(String fieldName, FieldDescriptor fieldDescriptor, T value, ProtoStreamWriterImpl writer, CodedOutputStream out) throws IOException {
        UnknownFieldSet unknownFieldSet;
        WriteMessageContext messageContext = writer.pushContext(fieldName, this, out);
        this.marshaller.writeTo(writer, value);
        if (value instanceof Message && (unknownFieldSet = ((Message)value).getUnknownFieldSet()) != null) {
            for (FieldDescriptor fd : this.getFieldDescriptors()) {
                if (!unknownFieldSet.hasTag(WireFormat.makeTag(fd.getNumber(), fd.getType().getWireType()))) continue;
                throw new IOException("Field " + fd.getFullName() + " is a known field so it is illegal to be present in the unknown field set");
            }
            unknownFieldSet.writeTo(messageContext.out);
        }
        unknownFieldSet = value instanceof Message ? ((Message)value).getUnknownFieldSet() : null;
        for (FieldDescriptor fd : this.getFieldDescriptors()) {
            if (!fd.isRequired() || messageContext.isFieldMarked(fd.getNumber()) || unknownFieldSet != null && unknownFieldSet.hasTag(WireFormat.makeTag(fd.getNumber(), fd.getType().getWireType()))) continue;
            throw new IllegalStateException("Required field \"" + fd.getFullName() + "\" should have been written by a calling a suitable method of " + MessageMarshaller.ProtoStreamWriter.class.getName());
        }
        writer.popContext();
    }

    @Override
    public T unmarshall(String fieldName, FieldDescriptor fieldDescriptor, ProtoStreamReaderImpl reader, CodedInputStream in) throws IOException {
        ReadMessageContext messageContext = reader.pushContext(fieldName, this, in);
        T a = this.marshaller.readFrom(reader);
        messageContext.unknownFieldSet.readAllFields(in);
        if (a instanceof Message && !messageContext.unknownFieldSet.isEmpty()) {
            ((Message)a).setUnknownFieldSet(messageContext.unknownFieldSet);
        }
        for (FieldDescriptor fd : this.getFieldDescriptors()) {
            if (!fd.isRequired() || messageContext.isFieldMarked(fd.getNumber()) || messageContext.unknownFieldSet.hasTag(WireFormat.makeTag(fd.getNumber(), fd.getType().getWireType()))) continue;
            throw new IOException("Required field \"" + fd.getFullName() + "\" was not encountered in the stream");
        }
        reader.popContext();
        return a;
    }
}

