/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.parser;

import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.infinispan.protostream.AnnotationParserException;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.impl.parser.AnnotationLexer;
import org.infinispan.protostream.impl.parser.AnnotationTokens;

public final class AnnotationParser {
    private final AnnotationLexer lexer;

    public AnnotationParser(String input) {
        this.lexer = new AnnotationLexer(input.toCharArray());
    }

    public Map<String, AnnotationElement.Annotation> parse() throws AnnotationParserException {
        LinkedHashMap<String, AnnotationElement.Annotation> annotations = new LinkedHashMap<String, AnnotationElement.Annotation>();
        while (this.lexer.token != AnnotationTokens.EOF) {
            AnnotationElement.Annotation annotation = this.parseAnnotation();
            if (annotations.containsKey(annotation.getName())) {
                throw this.syntaxError(annotation.position, "duplicate annotation definition \"{0}\"", annotation.getName());
            }
            annotations.put(annotation.getName(), annotation);
            this.lexer.skipNoise();
        }
        return annotations;
    }

    private void expect(AnnotationTokens token) {
        if (this.lexer.token != token) {
            long pos = AnnotationElement.line(this.lexer.pos) > AnnotationElement.line(this.lexer.lastPos) ? this.lexer.lastPos : this.lexer.pos;
            throw this.syntaxError(pos, "{0} expected", token.text);
        }
        this.lexer.nextToken();
    }

    private String identifier() {
        if (this.lexer.token == AnnotationTokens.IDENTIFIER) {
            String name = this.lexer.name;
            this.lexer.nextToken();
            return name;
        }
        this.expect(AnnotationTokens.IDENTIFIER);
        return null;
    }

    private String qualifiedIdentifier() {
        String qualIdent = this.identifier();
        while (this.lexer.token == AnnotationTokens.DOT) {
            this.lexer.nextToken();
            qualIdent = qualIdent + "." + this.identifier();
        }
        return qualIdent;
    }

    private AnnotationElement.Annotation parseAnnotation() {
        if (this.lexer.token == AnnotationTokens.AT) {
            long pos = this.lexer.pos;
            this.expect(AnnotationTokens.AT);
            String name = this.qualifiedIdentifier();
            Map<String, AnnotationElement.Attribute> attributes = this.parseAttributes();
            return new AnnotationElement.Annotation(pos, name, attributes);
        }
        throw this.syntaxError("annotation expected", new String[0]);
    }

    private Map<String, AnnotationElement.Attribute> parseAttributes() {
        LinkedHashMap<String, AnnotationElement.Attribute> members = new LinkedHashMap<String, AnnotationElement.Attribute>();
        if (this.lexer.token == AnnotationTokens.LPAREN) {
            int start = this.lexer.mark();
            this.expect(AnnotationTokens.LPAREN);
            switch (this.lexer.token) {
                case AT: {
                    long pos = this.lexer.pos;
                    AnnotationElement.Annotation annotation = this.parseAnnotation();
                    this.expect(AnnotationTokens.RPAREN);
                    AnnotationElement.Attribute attribute = new AnnotationElement.Attribute(pos, "value", annotation);
                    members.put(attribute.getName(), attribute);
                    return members;
                }
                case IDENTIFIER: {
                    long pos = this.lexer.pos;
                    AnnotationElement.Identifier identifier = this.parseIdentifier();
                    if (this.lexer.token == AnnotationTokens.EQ) {
                        start = this.lexer.mark();
                        this.expect(AnnotationTokens.EQ);
                        AnnotationElement.Value value = this.parseValue(start);
                        AnnotationElement.Attribute attribute = new AnnotationElement.Attribute(pos, identifier.getIdentifier(), value);
                        members.put(attribute.getName(), attribute);
                        break;
                    }
                    this.expect(AnnotationTokens.RPAREN);
                    AnnotationElement.Attribute attribute = new AnnotationElement.Attribute(pos, "value", identifier);
                    members.put(attribute.getName(), attribute);
                    return members;
                }
                case NULL: 
                case FALSE: 
                case TRUE: 
                case INT_LITERAL: 
                case LONG_LITERAL: 
                case FLOAT_LITERAL: 
                case DOUBLE_LITERAL: 
                case CHARACTER_LITERAL: 
                case STRING_LITERAL: {
                    long pos = this.lexer.pos;
                    AnnotationElement.Value literal = this.parseValue(start);
                    this.expect(AnnotationTokens.RPAREN);
                    AnnotationElement.Attribute attribute = new AnnotationElement.Attribute(pos, "value", literal);
                    members.put(attribute.getName(), attribute);
                    return members;
                }
            }
            if (this.lexer.token == AnnotationTokens.COMMA) {
                this.expect(AnnotationTokens.COMMA);
                while (this.lexer.token != AnnotationTokens.RPAREN && this.lexer.token != AnnotationTokens.EOF) {
                    AnnotationElement.Attribute attribute = this.parseAttribute();
                    if (members.containsKey(attribute.getName())) {
                        throw this.syntaxError(attribute.position, "duplicate annotation member definition \"{0}\"", attribute.getName());
                    }
                    members.put(attribute.getName(), attribute);
                    if (this.lexer.token == AnnotationTokens.RPAREN || this.lexer.token == AnnotationTokens.EOF) continue;
                    this.expect(AnnotationTokens.COMMA);
                }
            }
            this.expect(AnnotationTokens.RPAREN);
        }
        return members;
    }

    private AnnotationElement.Attribute parseAttribute() {
        long pos = this.lexer.pos;
        String name = this.identifier();
        int start = this.lexer.mark();
        this.expect(AnnotationTokens.EQ);
        AnnotationElement.Value value = this.parseValue(start);
        return new AnnotationElement.Attribute(pos, name, value);
    }

    private AnnotationElement.Value parseValue(int start) {
        long pos = this.lexer.pos;
        switch (this.lexer.token) {
            case AT: {
                return this.parseAnnotation();
            }
            case LBRACE: {
                return this.parseArray();
            }
            case IDENTIFIER: {
                return this.parseIdentifier();
            }
            case NULL: 
            case FALSE: 
            case TRUE: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case CHARACTER_LITERAL: 
            case STRING_LITERAL: {
                AnnotationTokens tok = this.lexer.token;
                String text = this.lexer.getText(start, this.lexer.mark());
                Object value = null;
                try {
                    switch (tok) {
                        case INT_LITERAL: {
                            value = Integer.parseInt(text.trim());
                            break;
                        }
                        case LONG_LITERAL: {
                            value = Long.parseLong(text.trim());
                            break;
                        }
                        case FLOAT_LITERAL: {
                            value = Float.valueOf(Float.parseFloat(text.trim()));
                            break;
                        }
                        case DOUBLE_LITERAL: {
                            value = Double.parseDouble(text.trim());
                            break;
                        }
                        case CHARACTER_LITERAL: {
                            value = Character.valueOf(text.charAt(1));
                            break;
                        }
                        case STRING_LITERAL: {
                            value = text.substring(text.indexOf("\"") + 1, text.length() - 1);
                            break;
                        }
                        case TRUE: {
                            value = Boolean.TRUE;
                            break;
                        }
                        case FALSE: {
                            value = Boolean.FALSE;
                            break;
                        }
                        case NULL: {
                            value = null;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    throw this.syntaxError("invalid numeric value: {0}", e.getMessage());
                }
                AnnotationElement.Literal literal = new AnnotationElement.Literal(pos, value);
                this.lexer.nextToken();
                return literal;
            }
        }
        throw this.syntaxError("literal expected", new String[0]);
    }

    private AnnotationElement.Identifier parseIdentifier() {
        long pos = this.lexer.pos;
        String qualIdent = this.qualifiedIdentifier();
        return new AnnotationElement.Identifier(pos, qualIdent);
    }

    private AnnotationElement.Array parseArray() {
        int start = this.lexer.mark();
        long pos = this.lexer.pos;
        this.expect(AnnotationTokens.LBRACE);
        LinkedList<AnnotationElement.Value> values = new LinkedList<AnnotationElement.Value>();
        while (this.lexer.token != AnnotationTokens.RBRACE && this.lexer.token != AnnotationTokens.EOF) {
            values.add(this.parseValue(start));
            start = this.lexer.mark();
            if (this.lexer.token == AnnotationTokens.RBRACE || this.lexer.token == AnnotationTokens.EOF) continue;
            this.expect(AnnotationTokens.COMMA);
        }
        this.expect(AnnotationTokens.RBRACE);
        return new AnnotationElement.Array(pos, values);
    }

    private AnnotationParserException syntaxError(long pos, String errorMsg, String ... errorArgs) {
        return new AnnotationParserException("Error: " + AnnotationElement.positionToString(pos) + ": " + MessageFormat.format(errorMsg, errorArgs));
    }

    private AnnotationParserException syntaxError(String errorMsg, String ... errorArgs) {
        return this.syntaxError(this.lexer.pos, errorMsg, errorArgs);
    }
}

