/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import infinispan.com.google.protobuf.CodedInputStream;
import infinispan.com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ProtoStreamReaderImpl;
import org.infinispan.protostream.impl.ProtoStreamWriterImpl;
import org.infinispan.protostream.impl.WireFormat;

public final class EnumMarshallerDelegate<T extends Enum<T>>
implements BaseMarshallerDelegate<T> {
    private final EnumMarshaller<T> enumMarshaller;
    private final EnumDescriptor enumDescriptor;
    private final Set<Integer> definedValues;

    public EnumMarshallerDelegate(EnumMarshaller<T> enumMarshaller, EnumDescriptor enumDescriptor) {
        this.enumMarshaller = enumMarshaller;
        this.enumDescriptor = enumDescriptor;
        List<EnumValueDescriptor> enumValues = enumDescriptor.getValues();
        this.definedValues = new HashSet<Integer>(enumValues.size());
        for (EnumValueDescriptor evd : enumValues) {
            this.definedValues.add(evd.getNumber());
        }
    }

    @Override
    public EnumMarshaller<T> getMarshaller() {
        return this.enumMarshaller;
    }

    public EnumDescriptor getEnumDescriptor() {
        return this.enumDescriptor;
    }

    public Set<Integer> getDefinedValues() {
        return this.definedValues;
    }

    @Override
    public void marshall(String fieldName, FieldDescriptor fd, T value, ProtoStreamWriterImpl writer, CodedOutputStream out) throws IOException {
        int enumValue = this.enumMarshaller.encode(value);
        if (!this.definedValues.contains(enumValue)) {
            throw new IllegalArgumentException("Undefined enum value : " + enumValue);
        }
        out.writeEnum(fd.getNumber(), enumValue);
    }

    @Override
    public T unmarshall(String fieldName, FieldDescriptor fieldDescriptor, ProtoStreamReaderImpl reader, CodedInputStream in) throws IOException {
        int enumValue;
        int expectedTag = WireFormat.makeTag(fieldDescriptor.getNumber(), 0);
        UnknownFieldSet unknownFieldSet = reader.getUnknownFieldSet();
        Object o = unknownFieldSet.consumeTag(expectedTag);
        if (o != null) {
            enumValue = ((Long)o).intValue();
        } else {
            while (true) {
                int tag;
                if ((tag = in.readTag()) == 0) {
                    return null;
                }
                if (tag == expectedTag) {
                    enumValue = in.readEnum();
                    break;
                }
                unknownFieldSet.readSingleField(tag, in);
            }
        }
        T decoded = this.enumMarshaller.decode(enumValue);
        if (decoded == null) {
            unknownFieldSet.putVarintField(expectedTag, enumValue);
        }
        return decoded;
    }
}

