/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.lang.reflect.Field;
import org.infinispan.protostream.annotations.impl.DocumentationExtractor;
import org.infinispan.protostream.annotations.impl.IndentWriter;

final class ProtoEnumValueMetadata {
    private final int number;
    private final String protoName;
    private final Field enumField;
    private final Enum enumValue;
    private final String documentation;

    public ProtoEnumValueMetadata(int number, String protoName, Field enumField, Enum enumValue) {
        this.number = number;
        this.protoName = protoName;
        this.enumField = enumField;
        this.enumValue = enumValue;
        this.documentation = DocumentationExtractor.getDocumentation(enumField);
    }

    public int getNumber() {
        return this.number;
    }

    public String getProtoName() {
        return this.protoName;
    }

    public Field getEnumField() {
        return this.enumField;
    }

    public Enum getEnumValue() {
        return this.enumValue;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void generateProto(IndentWriter iw) {
        iw.append("// field = ").append(this.enumField.getName()).append('\n');
        if (this.documentation != null) {
            iw.append("/*\n");
            iw.append(this.documentation).append('\n');
            iw.append("*/\n");
        }
        iw.append("   ").append(this.protoName).append(" = ").append(String.valueOf(this.number)).append(";\n");
    }
}

