/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.annotations.impl.DocumentationExtractor;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.descriptors.Type;

final class ProtoFieldMetadata {
    private static final Map<Type, String> typeNames = new HashMap<Type, String>();
    private final Class<?> declaringClass;
    private final int number;
    private final String name;
    private final Class<?> javaType;
    private final Class<?> collectionImplementation;
    private final Type protobufType;
    private final String documentation;
    private final ProtoTypeMetadata protoTypeMetadata;
    private final boolean isRequired;
    private final boolean isRepeated;
    private final Object defaultValue;
    private final String propertyName;
    private final Field field;
    private final Method getter;
    private final Method setter;

    public ProtoFieldMetadata(Class<?> declaringClass, int number, String name, Class<?> javaType, Class<?> collectionImplementation, Type protobufType, ProtoTypeMetadata protoTypeMetadata, boolean isRequired, boolean isRepeated, Object defaultValue, Field field) {
        this.declaringClass = declaringClass;
        this.number = number;
        this.name = name;
        this.javaType = javaType;
        this.collectionImplementation = collectionImplementation;
        this.protoTypeMetadata = protoTypeMetadata;
        this.isRequired = isRequired;
        this.isRepeated = isRepeated;
        this.defaultValue = defaultValue;
        this.protobufType = protobufType;
        this.propertyName = field.getName();
        this.field = field;
        this.getter = null;
        this.setter = null;
        this.documentation = DocumentationExtractor.getDocumentation(field);
    }

    public ProtoFieldMetadata(Class<?> declaringClass, int number, String name, Class<?> javaType, Class<?> collectionImplementation, Type protobufType, ProtoTypeMetadata protoTypeMetadata, boolean isRequired, boolean isRepeated, Object defaultValue, String propertyName, Method getter, Method setter) {
        this.declaringClass = declaringClass;
        this.number = number;
        this.name = name;
        this.javaType = javaType;
        this.collectionImplementation = collectionImplementation;
        this.protoTypeMetadata = protoTypeMetadata;
        this.isRequired = isRequired;
        this.isRepeated = isRepeated;
        this.defaultValue = defaultValue;
        this.protobufType = protobufType;
        this.field = null;
        this.propertyName = propertyName;
        this.getter = getter;
        this.setter = setter;
        this.documentation = DocumentationExtractor.getDocumentation(getter, setter);
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public Class<?> getCollectionImplementation() {
        return this.collectionImplementation;
    }

    public Type getProtobufType() {
        return this.protobufType;
    }

    public ProtoTypeMetadata getProtoTypeMetadata() {
        return this.protoTypeMetadata;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isRepeated() {
        return this.isRepeated;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Field getField() {
        return this.field;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public String getLocation() {
        return String.format("%s on property '%s' with tag number %d and name '%s'", this.declaringClass, this.propertyName, this.number, this.name);
    }

    public void generateProto(IndentWriter iw) {
        iw.append("// ");
        if (this.field != null) {
            iw.append("field = ").append(this.field.getName());
        } else {
            iw.append("getter = ").append(this.getter.getName()).append(", setter = ").append(this.setter.getName());
        }
        iw.append('\n');
        if (this.documentation != null) {
            iw.append("/*\n");
            iw.append(this.documentation).append('\n');
            iw.append("*/\n");
        }
        if (this.isRepeated) {
            iw.append("repeated ");
        } else {
            iw.append(this.isRequired ? "required " : "optional ");
        }
        String typeName = this.protobufType == Type.ENUM || this.protobufType == Type.MESSAGE || this.protobufType == Type.GROUP ? this.protoTypeMetadata.getFullName() : typeNames.get((Object)this.protobufType);
        iw.append(typeName);
        iw.append(' ').append(this.name).append(" = ").append(String.valueOf(this.number));
        Object defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            String v = defaultValue instanceof ProtoEnumValueMetadata ? ((ProtoEnumValueMetadata)defaultValue).getProtoName() : defaultValue.toString();
            iw.append(" [default = ").append(v).append(']');
        }
        iw.append(";\n");
    }

    static {
        typeNames.put(Type.DOUBLE, "double");
        typeNames.put(Type.FLOAT, "float");
        typeNames.put(Type.INT32, "int32");
        typeNames.put(Type.INT64, "int64");
        typeNames.put(Type.FIXED32, "fixed32");
        typeNames.put(Type.FIXED64, "fixed64");
        typeNames.put(Type.BOOL, "bool");
        typeNames.put(Type.STRING, "string");
        typeNames.put(Type.BYTES, "bytes");
        typeNames.put(Type.UINT32, "uint32");
        typeNames.put(Type.UINT64, "uint64");
        typeNames.put(Type.SFIXED32, "sfixed32");
        typeNames.put(Type.SFIXED64, "sfixed64");
        typeNames.put(Type.SINT32, "sint32");
        typeNames.put(Type.SINT64, "sint64");
    }
}

