/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import infinispan.javassist.ClassPool;
import infinispan.javassist.LoaderClassPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.MarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.impl.Log;

public final class ProtoSchemaGenerator {
    private static final Log log = Log.LogFactory.getLog(ProtoSchemaGenerator.class);
    private final SerializationContext serializationContext;
    private final String fileName;
    private final String packageName;
    private final Set<Class<?>> classes;
    private final Set<String> imports = new HashSet<String>();
    private final Map<Class<?>, ProtoTypeMetadata> metadataByClass = new HashMap();
    private final Map<String, ProtoTypeMetadata> metadataByTypeName = new HashMap<String, ProtoTypeMetadata>();

    public ProtoSchemaGenerator(SerializationContext serializationContext, String fileName, String packageName, Set<Class<?>> classes) {
        this.serializationContext = serializationContext;
        this.fileName = fileName;
        this.packageName = packageName;
        this.classes = classes;
    }

    public String generateAndRegister() throws ProtoSchemaBuilderException, IOException {
        ProtoTypeMetadata m;
        ArrayList<ProtoTypeMetadata> meta;
        for (Class<?> c : this.classes) {
            ProtoTypeMetadata protoTypeMetadata = c.isEnum() ? new ProtoEnumTypeMetadata(c) : new ProtoMessageTypeMetadata(this, c);
            this.defineType(protoTypeMetadata);
        }
        do {
            meta = new ArrayList<ProtoTypeMetadata>(this.metadataByClass.values());
            for (ProtoTypeMetadata protoTypeMetadata : meta) {
                protoTypeMetadata.scanMemberAnnotations();
            }
        } while (this.metadataByClass.size() != meta.size());
        for (Class<?> c : this.metadataByClass.keySet()) {
            ProtoMessageTypeMetadata protoMessageTypeMetadata = this.findOuterType(c);
            if (protoMessageTypeMetadata == null) continue;
            m = this.metadataByClass.get(c);
            m.setOuterType(protoMessageTypeMetadata);
            protoMessageTypeMetadata.addInnerType(m);
        }
        IndentWriter iw = new IndentWriter();
        iw.append("// File name: ").append(this.fileName).append('\n');
        iw.append("// Scanned classes:\n");
        for (ProtoTypeMetadata protoTypeMetadata : this.metadataByClass.values()) {
            if (!(protoTypeMetadata instanceof ProtoEnumTypeMetadata) && !(protoTypeMetadata instanceof ProtoMessageTypeMetadata)) continue;
            iw.append("//   ").append(protoTypeMetadata.getJavaClass().getCanonicalName()).append('\n');
        }
        if (this.packageName != null) {
            iw.append("\npackage ").append(this.packageName).append(";\n\n");
        }
        for (String string : this.imports) {
            iw.append("import \"").append(string).append("\";\n");
        }
        for (Class clazz : this.metadataByClass.keySet()) {
            m = this.metadataByClass.get(clazz);
            if (!m.isTopLevel()) continue;
            m.generateProto(iw);
        }
        String protoFile = iw.toString();
        log.tracef("Generated proto file:\n%s", (Object)protoFile);
        this.serializationContext.registerProtoFiles(FileDescriptorSource.fromString(this.fileName, protoFile));
        try {
            this.generateMarshallers();
        }
        catch (Exception exception) {
            throw new ProtoSchemaBuilderException("Failed to generate marshaller implementation class", exception);
        }
        return protoFile;
    }

    private ProtoMessageTypeMetadata findOuterType(Class<?> c) {
        ProtoTypeMetadata outer = null;
        for (Class<?> ec = c.getEnclosingClass(); ec != null; ec = ec.getEnclosingClass()) {
            if (ec.isEnum()) {
                throw new ProtoSchemaBuilderException("Classes defined inside an Enum are not allowed : " + c.getCanonicalName());
            }
            outer = this.metadataByClass.get(ec);
            if (outer != null) break;
        }
        return (ProtoMessageTypeMetadata)outer;
    }

    private void generateMarshallers() throws Exception {
        ClassPool cp = new ClassPool(ClassPool.getDefault());
        cp.appendClassPath(new LoaderClassPath(this.getClass().getClassLoader()));
        MarshallerCodeGenerator marshallerCodeGenerator = new MarshallerCodeGenerator(this.packageName, cp);
        for (Class<?> c : this.metadataByClass.keySet()) {
            BaseMarshaller marshaller;
            ProtoTypeMetadata ptm = this.metadataByClass.get(c);
            if (ptm instanceof ProtoMessageTypeMetadata) {
                marshaller = marshallerCodeGenerator.generateMessageMarshaller((ProtoMessageTypeMetadata)ptm);
                ptm.setMarshaller(marshaller);
                this.serializationContext.registerMarshaller(marshaller);
                continue;
            }
            if (!(ptm instanceof ProtoEnumTypeMetadata)) continue;
            marshaller = marshallerCodeGenerator.generateEnumMarshaller((ProtoEnumTypeMetadata)ptm);
            ptm.setMarshaller(marshaller);
            this.serializationContext.registerMarshaller(marshaller);
        }
    }

    protected ProtoTypeMetadata scanAnnotations(Class<?> javaType) {
        ProtoTypeMetadata protoTypeMetadata = this.metadataByClass.get(javaType);
        if (protoTypeMetadata != null) {
            return protoTypeMetadata;
        }
        if (this.serializationContext.canMarshall(javaType)) {
            BaseMarshaller<?> m = this.serializationContext.getMarshaller(javaType);
            protoTypeMetadata = new ProtoTypeMetadata(m);
            if (protoTypeMetadata.isEnum()) {
                this.imports.add(this.serializationContext.getEnumDescriptor(m.getTypeName()).getFileDescriptor().getName());
            } else {
                this.imports.add(this.serializationContext.getMessageDescriptor(m.getTypeName()).getFileDescriptor().getName());
            }
        } else {
            protoTypeMetadata = javaType.isEnum() ? new ProtoEnumTypeMetadata(javaType) : new ProtoMessageTypeMetadata(this, javaType);
        }
        this.defineType(protoTypeMetadata);
        return protoTypeMetadata;
    }

    private void defineType(ProtoTypeMetadata protoTypeMetadata) {
        String fullName = protoTypeMetadata.getFullName();
        ProtoTypeMetadata existing = this.metadataByTypeName.get(fullName);
        if (existing != null) {
            throw new ProtoSchemaBuilderException("Duplicate type definition. Type '" + fullName + "' is defined by " + protoTypeMetadata.getJavaClass() + " and by " + existing.getJavaClass());
        }
        this.metadataByTypeName.put(fullName, protoTypeMetadata);
        this.metadataByClass.put(protoTypeMetadata.getJavaClass(), protoTypeMetadata);
    }
}

