/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import java.util.concurrent.Callable;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.infinispan.Cache;
import org.infinispan.cdi.ContextInputCache;
import org.infinispan.cdi.util.BeanManagerProvider;
import org.infinispan.distexec.spi.DistributedTaskLifecycle;

public class CDIDistributedTaskLifecycle
implements DistributedTaskLifecycle {
    private final boolean HAVE_CDI;

    public CDIDistributedTaskLifecycle() {
        boolean success;
        try {
            this.getClass().getClassLoader().loadClass("javax.enterprise.inject.spi.BeanManager");
            success = true;
        }
        catch (ClassNotFoundException e) {
            success = false;
        }
        this.HAVE_CDI = success;
    }

    public <T, K, V> void onPreExecute(Callable<T> task, Cache<K, V> inputCache) {
        if (this.HAVE_CDI) {
            BeanManager bm = BeanManagerProvider.getInstance().getBeanManager();
            ContextInputCache.set(inputCache);
            Class<?> clazz = task.getClass();
            AnnotatedType type = bm.createAnnotatedType(clazz);
            InjectionTarget it = bm.createInjectionTarget(type);
            CreationalContext ctx = bm.createCreationalContext(null);
            it.inject(task, ctx);
            it.postConstruct(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void onPostExecute(Callable<T> task) {
        if (this.HAVE_CDI) {
            try {
                BeanManager bm = BeanManagerProvider.getInstance().getBeanManager();
                Class<?> clazz = task.getClass();
                AnnotatedType type = bm.createAnnotatedType(clazz);
                InjectionTarget it = bm.createInjectionTarget(type);
                it.preDestroy(task);
                it.dispose(task);
            }
            finally {
                ContextInputCache.clean();
            }
        }
    }
}

