/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.ProtoSchemaGenerator;

public final class ProtoSchemaBuilder {
    private String fileName;
    private String packageName;
    private final Set<Class<?>> classes = new HashSet();

    public ProtoSchemaBuilder fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ProtoSchemaBuilder packageName(String packageName) {
        if (packageName.trim().isEmpty()) {
            throw new IllegalArgumentException("packageName cannot be empty");
        }
        this.packageName = packageName;
        return this;
    }

    public ProtoSchemaBuilder addClass(Class<?> clazz) {
        this.classes.add(clazz);
        return this;
    }

    public String build(SerializationContext serializationContext) throws ProtoSchemaBuilderException, IOException {
        if (this.fileName == null) {
            throw new ProtoSchemaBuilderException("fileName cannot be null");
        }
        if (this.classes.isEmpty()) {
            throw new ProtoSchemaBuilderException("At least one class must be specified");
        }
        return new ProtoSchemaGenerator(serializationContext, this.fileName, this.packageName, this.classes).generateAndRegister();
    }
}

