/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.WrappedMessageMarshaller;

public final class ProtobufUtil {
    private static final String WRAPPING_DEFINITIONS_RES = "/org/infinispan/protostream/message-wrapping.proto";

    public static SerializationContext newSerializationContext(Configuration configuration) {
        SerializationContextImpl serializationContext = new SerializationContextImpl(configuration);
        try {
            serializationContext.registerProtoFiles(FileDescriptorSource.fromResources(WRAPPING_DEFINITIONS_RES));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize serialization context", e);
        }
        catch (DescriptorParserException e) {
            throw new RuntimeException("Failed to initialize serialization context", e);
        }
        serializationContext.registerMarshaller(new WrappedMessageMarshaller());
        return serializationContext;
    }

    private static <A> void writeTo(SerializationContext ctx, RawProtoStreamWriter out, A t) throws IOException {
        if (t == null) {
            throw new IllegalArgumentException("Object to marshall cannot be null");
        }
        BaseMarshallerDelegate<?> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(t.getClass());
        marshallerDelegate.marshall(null, t, null, out);
        out.flush();
    }

    public static void writeTo(SerializationContext ctx, OutputStream out, Object t) throws IOException {
        ProtobufUtil.writeTo(ctx, RawProtoStreamWriterImpl.newInstance(out), t);
    }

    public static byte[] toByteArray(SerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.toByteArray();
    }

    public static ByteBuffer toByteBuffer(SerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx();
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.getByteBuffer();
    }

    private static <A> A readFrom(SerializationContext ctx, RawProtoStreamReader in, Class<A> clazz) throws IOException {
        BaseMarshallerDelegate<A> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(clazz);
        return marshallerDelegate.unmarshall(null, null, in);
    }

    public static <A> A readFrom(SerializationContext ctx, InputStream in, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(in), clazz);
    }

    public static <A> A fromByteArray(SerializationContext ctx, byte[] bytes, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(bytes), clazz);
    }

    public static <A> A fromByteArray(SerializationContext ctx, byte[] bytes, int offset, int length, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(bytes, offset, length), clazz);
    }

    public static <A> A fromByteBuffer(SerializationContext ctx, ByteBuffer byteBuffer, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(byteBuffer), clazz);
    }

    public static Object fromWrappedByteArray(SerializationContext ctx, byte[] bytes) throws IOException {
        return ProtobufUtil.fromWrappedByteArray(ctx, bytes, 0, bytes.length);
    }

    public static Object fromWrappedByteArray(SerializationContext ctx, byte[] bytes, int offset, int length) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes, offset, length);
        return WrappedMessageMarshaller.readWrappedMessage(ctx, RawProtoStreamReaderImpl.newInstance(bais));
    }

    public static Object fromWrappedByteBuffer(SerializationContext ctx, ByteBuffer byteBuffer) throws IOException {
        return WrappedMessageMarshaller.readWrappedMessage(ctx, RawProtoStreamReaderImpl.newInstance(byteBuffer));
    }

    public static byte[] toWrappedByteArray(SerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WrappedMessageMarshaller.writeWrappedMessage(ctx, RawProtoStreamWriterImpl.newInstance(baos), t);
        return baos.toByteArray();
    }

    public static ByteBuffer toWrappedByteBuffer(SerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx();
        WrappedMessageMarshaller.writeWrappedMessage(ctx, RawProtoStreamWriterImpl.newInstance(baos), t);
        return baos.getByteBuffer();
    }
}

