/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;

public class QueryOperation
extends RetryOnFailureOperation<QueryResponse> {
    private final RemoteQuery remoteQuery;

    public QueryOperation(Codec codec, TransportFactory transportFactory, byte[] cacheName, AtomicInteger topologyId, Flag[] flags, RemoteQuery remoteQuery) {
        super(codec, transportFactory, cacheName, topologyId, flags);
        this.remoteQuery = remoteQuery;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.transportFactory.getTransport(failedServers, this.cacheName);
    }

    @Override
    protected QueryResponse executeOperation(Transport transport) {
        byte[] requestBytes;
        HeaderParams params = this.writeHeader(transport, (short)31);
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setJpqlString(this.remoteQuery.getJPAQuery());
        queryRequest.setStartOffset(this.remoteQuery.getStartOffset());
        queryRequest.setMaxResults(this.remoteQuery.getMaxResults());
        SerializationContext serCtx = this.remoteQuery.getSerializationContext();
        try {
            requestBytes = ProtobufUtil.toByteArray(serCtx, queryRequest);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
        transport.writeArray(requestBytes);
        transport.flush();
        this.readHeaderAndValidate(transport, params);
        byte[] responseBytes = transport.readArray();
        try {
            QueryResponse queryResponse = ProtobufUtil.fromByteArray(serCtx, responseBytes, QueryResponse.class);
            return queryResponse;
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }
}

