/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetKeysOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetOperation;
import org.infinispan.client.hotrod.impl.operations.ClearOperation;
import org.infinispan.client.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.client.hotrod.impl.operations.ExecuteOperation;
import org.infinispan.client.hotrod.impl.operations.FaultTolerantPingOperation;
import org.infinispan.client.hotrod.impl.operations.GetOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithVersionOperation;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.operations.PutAllOperation;
import org.infinispan.client.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.client.hotrod.impl.operations.PutOperation;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.client.hotrod.impl.operations.SizeOperation;
import org.infinispan.client.hotrod.impl.operations.StatsOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public class OperationsFactory
implements HotRodConstants {
    private static final Flag[] FORCE_RETURN_VALUE = new Flag[]{Flag.FORCE_RETURN_VALUE};
    private final ThreadLocal<List<Flag>> flagsMap = new ThreadLocal();
    private final TransportFactory transportFactory;
    private final byte[] cacheNameBytes;
    private final AtomicInteger topologyId;
    private final boolean forceReturnValue;
    private final Codec codec;
    private final ClientListenerNotifier listenerNotifier;

    public OperationsFactory(TransportFactory transportFactory, String cacheName, AtomicInteger topologyId, boolean forceReturnValue, Codec codec, ClientListenerNotifier listenerNotifier) {
        this.transportFactory = transportFactory;
        this.cacheNameBytes = RemoteCacheManager.cacheNameBytes(cacheName);
        this.topologyId = topologyId;
        this.forceReturnValue = forceReturnValue;
        this.codec = codec;
        this.listenerNotifier = listenerNotifier;
    }

    public ClientListenerNotifier getListenerNotifier() {
        return this.listenerNotifier;
    }

    public byte[] getCacheName() {
        return this.cacheNameBytes;
    }

    public GetOperation newGetKeyOperation(byte[] key) {
        return new GetOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public RemoveOperation newRemoveOperation(byte[] key) {
        return new RemoveOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public RemoveIfUnmodifiedOperation newRemoveIfUnmodifiedOperation(byte[] key, long version) {
        return new RemoveIfUnmodifiedOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(), version);
    }

    public ReplaceIfUnmodifiedOperation newReplaceIfUnmodifiedOperation(byte[] key, byte[] value, int lifespanSeconds, int maxIdleTimeSeconds, long version) {
        return new ReplaceIfUnmodifiedOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(), value, lifespanSeconds, maxIdleTimeSeconds, version);
    }

    public GetWithVersionOperation newGetWithVersionOperation(byte[] key) {
        return new GetWithVersionOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public GetWithMetadataOperation newGetWithMetadataOperation(byte[] key) {
        return new GetWithMetadataOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public StatsOperation newStatsOperation() {
        return new StatsOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public PutOperation newPutKeyValueOperation(byte[] key, byte[] value, int lifespanSecs, int maxIdleSecs) {
        return new PutOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(), value, lifespanSecs, maxIdleSecs);
    }

    public PutAllOperation newPutAllOperation(Map<byte[], byte[]> map, int lifespanSecs, int maxIdleSecs) {
        return new PutAllOperation(this.codec, this.transportFactory, map, this.cacheNameBytes, this.topologyId, this.flags(), lifespanSecs, maxIdleSecs);
    }

    public PutIfAbsentOperation newPutIfAbsentOperation(byte[] key, byte[] value, int lifespanSecs, int maxIdleSecs) {
        return new PutIfAbsentOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(), value, lifespanSecs, maxIdleSecs);
    }

    public ReplaceOperation newReplaceOperation(byte[] key, byte[] values, int lifespanSecs, int maxIdleSecs) {
        return new ReplaceOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(), values, lifespanSecs, maxIdleSecs);
    }

    public ContainsKeyOperation newContainsKeyOperation(byte[] key) {
        return new ContainsKeyOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public ClearOperation newClearOperation() {
        return new ClearOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public BulkGetOperation newBulkGetOperation(int size) {
        return new BulkGetOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), size);
    }

    public BulkGetKeysOperation newBulkGetKeysOperation(int scope) {
        return new BulkGetKeysOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), scope);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener) {
        return new AddClientListenerOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.listenerNotifier, listener, null, null);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        return new AddClientListenerOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.listenerNotifier, listener, filterFactoryParams, converterFactoryParams);
    }

    public RemoveClientListenerOperation newRemoveClientListenerOperation(Object listener) {
        return new RemoveClientListenerOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.listenerNotifier, listener);
    }

    public PingOperation newPingOperation(Transport transport) {
        return new PingOperation(this.codec, this.topologyId, transport, this.cacheNameBytes);
    }

    public FaultTolerantPingOperation newFaultTolerantPingOperation() {
        return new FaultTolerantPingOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public QueryOperation newQueryOperation(RemoteQuery remoteQuery) {
        return new QueryOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), remoteQuery);
    }

    public SizeOperation newSizeOperation() {
        return new SizeOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public ExecuteOperation newExecuteOperation(String taskName, Map<String, byte[]> marshalledParams) {
        return new ExecuteOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), taskName, marshalledParams);
    }

    private Flag[] flags() {
        List<Flag> flags = this.flagsMap.get();
        this.flagsMap.remove();
        if (this.forceReturnValue) {
            if (flags == null) {
                return FORCE_RETURN_VALUE;
            }
            flags.add(Flag.FORCE_RETURN_VALUE);
        }
        return flags != null ? flags.toArray(new Flag[0]) : null;
    }

    public void setFlags(Flag[] flags) {
        ArrayList<Flag> list = new ArrayList<Flag>();
        for (Flag flag : flags) {
            list.add(flag);
        }
        this.flagsMap.set(list);
    }

    public void addFlags(Flag ... flags) {
        List<Flag> list = this.flagsMap.get();
        if (list == null) {
            list = new ArrayList<Flag>();
            this.flagsMap.set(list);
        }
        for (Flag flag : flags) {
            list.add(flag);
        }
    }
}

