/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import infinispan.org.apache.commons.pool.impl.GenericKeyedObjectPool;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.configuration.SslConfiguration;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.PropsKeyedObjectPoolFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.SaslTransportObjectFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TransportObjectFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.commons.util.Util;

@ThreadSafe
public class TcpTransportFactory
implements TransportFactory {
    private static final Log log = LogFactory.getLog(TcpTransportFactory.class, Log.class);
    private final Object lock = new Object();
    private GenericKeyedObjectPool<SocketAddress, TcpTransport> connectionPool;
    private Map<byte[], FailoverRequestBalancingStrategy> balancers;
    private Map<byte[], ConsistentHash> consistentHashes;
    private Configuration configuration;
    private Collection<SocketAddress> servers;
    private Collection<SocketAddress> initialServers;
    private final ConsistentHashFactory hashFactory = new ConsistentHashFactory();
    private volatile boolean tcpNoDelay;
    private volatile boolean tcpKeepAlive;
    private volatile int soTimeout;
    private volatile int connectTimeout;
    private volatile int maxRetries;
    private volatile SSLContext sslContext;
    private volatile ClientListenerNotifier listenerNotifier;
    private volatile AtomicInteger topologyId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Codec codec, Configuration configuration, AtomicInteger defaultCacheTopologyId, ClientListenerNotifier listenerNotifier) {
        Object object = this.lock;
        synchronized (object) {
            this.listenerNotifier = listenerNotifier;
            this.configuration = configuration;
            this.hashFactory.init(configuration);
            boolean pingOnStartup = configuration.pingOnStartup();
            this.servers = new ArrayList<SocketAddress>();
            this.initialServers = new ArrayList<SocketAddress>();
            for (ServerConfiguration server : configuration.servers()) {
                this.servers.add(new InetSocketAddress(server.host(), server.port()));
            }
            this.initialServers.addAll(this.servers);
            this.servers = Collections.unmodifiableCollection(this.servers);
            this.tcpNoDelay = configuration.tcpNoDelay();
            this.tcpKeepAlive = configuration.tcpKeepAlive();
            this.soTimeout = configuration.socketTimeout();
            this.connectTimeout = configuration.connectionTimeout();
            this.maxRetries = configuration.maxRetries();
            this.topologyId = defaultCacheTopologyId;
            if (configuration.security().ssl().enabled()) {
                SslConfiguration ssl = configuration.security().ssl();
                this.sslContext = ssl.sslContext() != null ? ssl.sslContext() : SslContextFactory.getContext(ssl.keyStoreFileName(), ssl.keyStorePassword(), ssl.trustStoreFileName(), ssl.trustStorePassword());
            }
            if (log.isDebugEnabled()) {
                log.debugf("Statically configured servers: %s", (Object)this.servers);
                log.debugf("Load balancer class: %s", (Object)configuration.balancingStrategy().getName());
                log.debugf("Tcp no delay = %b; client socket timeout = %d ms; connect timeout = %d ms", (Object)this.tcpNoDelay, (Object)this.soTimeout, (Object)this.connectTimeout);
            }
            TransportObjectFactory connectionFactory = configuration.security().authentication().enabled() ? new SaslTransportObjectFactory(codec, this, defaultCacheTopologyId, pingOnStartup, configuration.security().authentication()) : new TransportObjectFactory(codec, this, defaultCacheTopologyId, pingOnStartup);
            PropsKeyedObjectPoolFactory<SocketAddress, TcpTransport> poolFactory = new PropsKeyedObjectPoolFactory<SocketAddress, TcpTransport>(connectionFactory, configuration.connectionPool());
            this.createAndPreparePool(poolFactory);
            this.balancers = CollectionFactory.makeMap(ByteArrayEquivalence.INSTANCE, AnyEquivalence.getInstance());
            this.consistentHashes = CollectionFactory.makeMap(ByteArrayEquivalence.INSTANCE, AnyEquivalence.getInstance());
            this.addBalancer(RemoteCacheManager.cacheNameBytes());
        }
        if (configuration.pingOnStartup()) {
            this.pingServers();
        }
    }

    private FailoverRequestBalancingStrategy addBalancer(byte[] cacheName) {
        RequestBalancingStrategy cfgBalancer = Util.getInstance(this.configuration.balancingStrategy());
        FailoverRequestBalancingStrategy balancer = cfgBalancer instanceof FailoverRequestBalancingStrategy ? (FailoverRequestBalancingStrategy)cfgBalancer : new FailoverToRequestBalancingStrategyDelegate(cfgBalancer);
        this.balancers.put(cacheName, balancer);
        balancer.setServers(this.servers);
        return balancer;
    }

    private void pingServers() {
        GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
        for (SocketAddress addr : this.servers) {
            try {
                pool.returnObject(addr, pool.borrowObject(addr));
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) continue;
                log.tracef((Throwable)e, "Ignoring exception pinging configured servers %s to establish a connection", (Object)this.servers);
            }
        }
    }

    private void createAndPreparePool(PropsKeyedObjectPoolFactory<SocketAddress, TcpTransport> poolFactory) {
        this.connectionPool = (GenericKeyedObjectPool)poolFactory.createPool();
        for (SocketAddress addr : this.servers) {
            this.connectionPool.preparePool(addr, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.connectionPool.clear();
            try {
                this.connectionPool.close();
            }
            catch (Exception e) {
                log.warn("Exception while shutting down the connection pool.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHashFunction(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, short hashFunctionVersion, int hashSpace, byte[] cacheName) {
        Object object = this.lock;
        synchronized (object) {
            Object hash = this.hashFactory.newConsistentHash(hashFunctionVersion);
            if (hash == null) {
                log.noHasHFunctionConfigured(hashFunctionVersion);
            } else {
                hash.init(servers2Hash, numKeyOwners, hashSpace);
            }
            this.consistentHashes.put(cacheName, (ConsistentHash)hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHashFunction(SocketAddress[][] segmentOwners, int numSegments, short hashFunctionVersion, byte[] cacheName) {
        Object object = this.lock;
        synchronized (object) {
            SegmentConsistentHash hash = (SegmentConsistentHash)this.hashFactory.newConsistentHash(hashFunctionVersion);
            if (hash == null) {
                log.noHasHFunctionConfigured(hashFunctionVersion);
            } else {
                hash.init(segmentOwners, numSegments);
            }
            this.consistentHashes.put(cacheName, hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transport getTransport(Set<SocketAddress> failedServers, byte[] cacheName) {
        SocketAddress server;
        Object object = this.lock;
        synchronized (object) {
            server = this.getNextServer(failedServers, cacheName);
        }
        return this.borrowTransportFromPool(server);
    }

    private SocketAddress getNextServer(Set<SocketAddress> failedServers, byte[] cacheName) {
        FailoverRequestBalancingStrategy balancer = this.getOrCreateIfAbsentBalancer(cacheName);
        SocketAddress server = balancer.nextServer(failedServers);
        if (log.isTraceEnabled()) {
            log.tracef("Using the balancer for determining the server: %s", (Object)server);
        }
        return server;
    }

    private FailoverRequestBalancingStrategy getOrCreateIfAbsentBalancer(byte[] cacheName) {
        FailoverRequestBalancingStrategy balancer = this.balancers.get(cacheName);
        if (balancer == null) {
            balancer = this.addBalancer(cacheName);
        }
        return balancer;
    }

    @Override
    public Transport getAddressTransport(SocketAddress server) {
        return this.borrowTransportFromPool(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transport getTransport(byte[] key, Set<SocketAddress> failedServers, byte[] cacheName) {
        SocketAddress server;
        Object object = this.lock;
        synchronized (object) {
            ConsistentHash consistentHash = this.consistentHashes.get(cacheName);
            if (consistentHash != null) {
                server = consistentHash.getServer(key);
                if (log.isTraceEnabled()) {
                    log.tracef("Using consistent hash for determining the server: " + server, new Object[0]);
                }
            } else {
                server = this.getNextServer(failedServers, cacheName);
            }
        }
        return this.borrowTransportFromPool(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseTransport(Transport transport) {
        GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
        TcpTransport tcpTransport = (TcpTransport)transport;
        if (!tcpTransport.isValid()) {
            try {
                if (log.isTraceEnabled()) {
                    log.tracef("Dropping connection as it is no longer valid: %s", (Object)tcpTransport);
                }
                pool.invalidateObject(tcpTransport.getServerAddress(), tcpTransport);
            }
            catch (Exception e) {
                log.couldNoInvalidateConnection(tcpTransport, e);
            }
        } else {
            try {
                pool.returnObject(tcpTransport.getServerAddress(), tcpTransport);
            }
            catch (Exception e) {
                log.couldNotReleaseConnection(tcpTransport, e);
            }
            finally {
                this.logConnectionInfo(tcpTransport.getServerAddress());
            }
        }
    }

    @Override
    public void invalidateTransport(SocketAddress serverAddress, Transport transport) {
        GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
        try {
            pool.invalidateObject(serverAddress, (TcpTransport)transport);
        }
        catch (Exception e) {
            log.unableToInvalidateTransport(serverAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateServers(Collection<SocketAddress> newServers, byte[] cacheName, boolean quiet) {
        Object object = this.lock;
        synchronized (object) {
            HashSet<SocketAddress> addedServers = new HashSet<SocketAddress>(newServers);
            addedServers.removeAll(this.servers);
            HashSet<SocketAddress> failedServers = new HashSet<SocketAddress>(this.servers);
            failedServers.removeAll(newServers);
            if (log.isTraceEnabled()) {
                log.tracef("Current list: %s", (Object)this.servers);
                log.tracef("New list: %s", (Object)newServers);
                log.tracef("Added servers: %s", (Object)addedServers);
                log.tracef("Removed servers: %s", (Object)failedServers);
            }
            if (failedServers.isEmpty() && addedServers.isEmpty()) {
                log.debug("Same list of servers, not changing the pool");
                return;
            }
            for (SocketAddress server : addedServers) {
                log.newServerAdded(server);
                try {
                    this.connectionPool.addObject(server);
                }
                catch (Exception e) {
                    if (quiet) continue;
                    log.failedAddingNewServer(server, e);
                }
            }
            for (SocketAddress server : failedServers) {
                log.removingServer(server);
                this.connectionPool.clear(server);
            }
            this.servers = Collections.unmodifiableList(new ArrayList<SocketAddress>(newServers));
            if (!failedServers.isEmpty()) {
                this.listenerNotifier.failoverClientListeners(failedServers);
            }
            FailoverRequestBalancingStrategy balancer = this.getOrCreateIfAbsentBalancer(cacheName);
            balancer.setServers(this.servers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SocketAddress> getServers() {
        Object object = this.lock;
        synchronized (object) {
            return this.servers;
        }
    }

    private void logConnectionInfo(SocketAddress server) {
        if (log.isTraceEnabled()) {
            GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
            log.tracef("For server %s: active = %d; idle = %d", (Object)server, (Object)pool.getNumActive(server), (Object)pool.getNumIdle(server));
        }
    }

    private Transport borrowTransportFromPool(SocketAddress server) {
        GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
        try {
            Transport transport = (Transport)pool.borrowObject(server);
            return transport;
        }
        catch (Exception e) {
            String message = "Could not fetch transport";
            log.debug(message, e);
            throw new TransportException(message, e, server);
        }
        finally {
            this.logConnectionInfo(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsistentHash getConsistentHash(byte[] cacheName) {
        Object object = this.lock;
        synchronized (object) {
            return this.consistentHashes.get(cacheName);
        }
    }

    @Override
    public ConsistentHashFactory getConsistentHashFactory() {
        return this.hashFactory;
    }

    @Override
    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Override
    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    @Override
    public int getMaxRetries() {
        if (Thread.currentThread().isInterrupted()) {
            return -1;
        }
        return this.maxRetries;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public void reset(byte[] cacheName) {
        this.updateServers(this.initialServers, cacheName, true);
        this.topologyId.set(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestBalancingStrategy getBalancer(byte[] cacheName) {
        Object object = this.lock;
        synchronized (object) {
            return this.balancers.get(cacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericKeyedObjectPool<SocketAddress, TcpTransport> getConnectionPool() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionPool;
        }
    }

    private static class FailoverToRequestBalancingStrategyDelegate
    implements FailoverRequestBalancingStrategy {
        final RequestBalancingStrategy delegate;

        private FailoverToRequestBalancingStrategyDelegate(RequestBalancingStrategy delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setServers(Collection<SocketAddress> servers) {
            this.delegate.setServers(servers);
        }

        @Override
        public SocketAddress nextServer() {
            return this.delegate.nextServer();
        }

        @Override
        public SocketAddress nextServer(Set<SocketAddress> failedServers) {
            return this.delegate.nextServer();
        }
    }
}

