/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.consistenthash;

import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.Util;

public final class SegmentConsistentHash
implements ConsistentHash {
    private static final Log log = LogFactory.getLog(SegmentConsistentHash.class);
    private final Hash hash = MurmurHash3.getInstance();
    private SocketAddress[][] segmentOwners;
    private int numSegments;
    private int segmentSize;

    @Override
    public void init(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, int hashSpace) {
    }

    public void init(SocketAddress[][] segmentOwners, int numSegments) {
        this.segmentOwners = segmentOwners;
        this.numSegments = numSegments;
        this.segmentSize = Util.getSegmentSize(numSegments);
    }

    @Override
    public SocketAddress getServer(byte[] key) {
        int segmentId = this.getSegment(key);
        if (log.isTraceEnabled()) {
            log.tracef("Find server in segment id %s for key %s", (Object)segmentId, (Object)Util.toHexString(key));
        }
        return this.segmentOwners[segmentId][0];
    }

    public int getSegment(Object key) {
        return this.getNormalizedHash(key) / this.segmentSize;
    }

    @Override
    public int getNormalizedHash(Object object) {
        return Util.getNormalizedHash(object, this.hash);
    }

    @Override
    public Map<SocketAddress, Set<Integer>> getSegmentsByServer() {
        HashMap map = new HashMap();
        IntStream.range(0, this.segmentOwners.length).forEach(seg -> {
            SocketAddress[] owners = this.segmentOwners[seg];
            Arrays.stream(owners).forEach(s -> map.computeIfAbsent(s, k -> new HashSet(owners.length)).add(seg));
        });
        return Immutables.immutableMapWrap(map);
    }

    public int getNumSegments() {
        return this.numSegments;
    }

    public SocketAddress[][] getSegmentOwners() {
        return this.segmentOwners;
    }
}

