/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.security.sasl.SaslClient;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.transport.AbstractTransport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.SaslInputStream;
import org.infinispan.client.hotrod.impl.transport.tcp.SaslOutputStream;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.io.SignedNumeric;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.Util;

public class TcpTransport
extends AbstractTransport {
    private static AtomicLong ID_COUNTER = new AtomicLong(0L);
    private static final Log log = LogFactory.getLog(TcpTransport.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Socket socket;
    private final SocketChannel socketChannel;
    private InputStream socketInputStream;
    private OutputStream socketOutputStream;
    private final SocketAddress serverAddress;
    private final long id = ID_COUNTER.incrementAndGet();
    private volatile boolean invalid;
    private SaslClient saslClient;

    public TcpTransport(SocketAddress serverAddress, TransportFactory transportFactory) {
        super(transportFactory);
        this.serverAddress = serverAddress;
        try {
            if (transportFactory.getSSLContext() != null) {
                SSLContext sslContext = transportFactory.getSSLContext();
                this.socketChannel = null;
                this.socket = sslContext.getSocketFactory().createSocket();
            } else {
                this.socketChannel = SocketChannel.open();
                this.socket = this.socketChannel.socket();
            }
            this.socket.connect(serverAddress, transportFactory.getConnectTimeout());
            this.socket.setTcpNoDelay(transportFactory.isTcpNoDelay());
            this.socket.setKeepAlive(transportFactory.isTcpKeepAlive());
            this.socket.setSoTimeout(transportFactory.getSoTimeout());
            this.socketInputStream = new BufferedInputStream(this.socket.getInputStream(), this.socket.getReceiveBufferSize());
            this.socketOutputStream = new BufferedOutputStream(this.socket.getOutputStream(), this.socket.getSendBufferSize());
        }
        catch (Exception e) {
            String message = String.format("Could not connect to server: %s", serverAddress);
            log.tracef((Throwable)e, "Could not connect to server: %s", (Object)serverAddress);
            throw new TransportException(message, e, serverAddress);
        }
    }

    void setSaslClient(SaslClient saslClient) {
        this.saslClient = saslClient;
        try {
            this.socketInputStream = new SaslInputStream(this.socket.getInputStream(), saslClient);
            this.socketOutputStream = new SaslOutputStream(this.socket.getOutputStream(), saslClient);
        }
        catch (IOException e) {
            this.invalid = true;
            throw new TransportException(e, this.serverAddress);
        }
    }

    @Override
    public void writeVInt(int vInt) {
        try {
            UnsignedNumeric.writeUnsignedInt(this.socketOutputStream, vInt);
        }
        catch (IOException e) {
            this.invalid = true;
            throw new TransportException(e, this.serverAddress);
        }
    }

    @Override
    public void writeSignedVInt(int vInt) {
        try {
            SignedNumeric.writeSignedInt(this.socketOutputStream, vInt);
        }
        catch (IOException e) {
            this.invalid = true;
            throw new TransportException(e, this.serverAddress);
        }
    }

    @Override
    public void writeVLong(long l) {
        try {
            UnsignedNumeric.writeUnsignedLong(this.socketOutputStream, l);
        }
        catch (IOException e) {
            this.invalid = true;
            throw new TransportException(e, this.serverAddress);
        }
    }

    @Override
    public long readVLong() {
        try {
            return UnsignedNumeric.readUnsignedLong(this.socketInputStream);
        }
        catch (IOException e) {
            this.invalid = true;
            throw new TransportException(e, this.serverAddress);
        }
    }

    @Override
    public int readVInt() {
        try {
            return UnsignedNumeric.readUnsignedInt(this.socketInputStream);
        }
        catch (IOException e) {
            this.invalid = true;
            throw new TransportException(e, this.serverAddress);
        }
    }

    @Override
    protected void writeBytes(byte[] toAppend) {
        try {
            this.socketOutputStream.write(toAppend);
            if (trace) {
                log.tracef("Wrote %d bytes", (Object)toAppend.length);
            }
        }
        catch (IOException e) {
            this.invalid = true;
            throw new TransportException("Problems writing data to stream", e, this.serverAddress);
        }
    }

    @Override
    public void writeByte(short toWrite) {
        try {
            this.socketOutputStream.write(toWrite);
            if (trace) {
                log.tracef("Wrote byte %d", (Object)toWrite);
            }
        }
        catch (IOException e) {
            this.invalid = true;
            throw new TransportException("Problems writing data to stream", e, this.serverAddress);
        }
    }

    @Override
    public void flush() {
        try {
            this.socketOutputStream.flush();
            if (trace) {
                log.tracef("Flushed socket: %s", (Object)this.socket);
            }
        }
        catch (IOException e) {
            this.invalid = true;
            throw new TransportException(e, this.serverAddress);
        }
    }

    @Override
    public short readByte() {
        int resultInt;
        try {
            resultInt = this.socketInputStream.read();
            if (trace) {
                log.tracef("Read byte %d from socket input in %s", (Object)resultInt, (Object)this.socket);
            }
        }
        catch (IOException e) {
            this.invalid = true;
            throw new TransportException(e, this.serverAddress);
        }
        if (resultInt == -1) {
            throw new TransportException("End of stream reached!", this.serverAddress);
        }
        return (short)resultInt;
    }

    @Override
    public void release() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.invalid = true;
            log.errorClosingSocket(this, e);
        }
    }

    @Override
    public byte[] readByteArray(int size) {
        byte[] result = new byte[size];
        boolean done = false;
        int offset = 0;
        do {
            int read;
            try {
                int len = size - offset;
                if (trace) {
                    log.tracef("Offset: %d, len=%d, size=%d", (Object)offset, (Object)len, (Object)size);
                }
                read = this.socketInputStream.read(result, offset, len);
            }
            catch (IOException e) {
                this.invalid = true;
                throw new TransportException(e, this.serverAddress);
            }
            if (read == -1) {
                throw new RuntimeException("End of stream reached!");
            }
            if (read + offset == size) {
                done = true;
                continue;
            }
            if ((offset += read) <= result.length) continue;
            throw new IllegalStateException("Assertion!");
        } while (!done);
        if (trace) {
            log.tracef("Successfully read array with size: %d", (Object)size);
        }
        return result;
    }

    public SocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public String toString() {
        return "TcpTransport{socket=" + this.socket + ", serverAddress=" + this.serverAddress + ", id =" + this.id + "} ";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TcpTransport that = (TcpTransport)o;
        if (this.serverAddress != null ? !this.serverAddress.equals(that.serverAddress) : that.serverAddress != null) {
            return false;
        }
        return !(this.socket != null ? !this.socket.equals(that.socket) : that.socket != null);
    }

    public int hashCode() {
        int result = this.socket != null ? this.socket.hashCode() : 0;
        result = 31 * result + (this.serverAddress != null ? this.serverAddress.hashCode() : 0);
        return result;
    }

    public void destroy() {
        try {
            if (this.socketInputStream != null) {
                this.socketInputStream.close();
            }
            if (this.socketOutputStream != null) {
                this.socketOutputStream.close();
            }
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.saslClient != null) {
                this.saslClient.dispose();
            }
            if (trace) {
                log.tracef("Successfully closed socket: %s", (Object)this.socket);
            }
        }
        catch (IOException e) {
            this.invalid = true;
            log.errorClosingSocket(this, e);
            Util.close(this.socketInputStream, this.socketOutputStream, this.socketChannel);
            Util.close(this.socket);
        }
    }

    @Override
    public boolean isValid() {
        return !this.socket.isClosed() && !this.invalid;
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] dumpStream() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.socket.setSoTimeout(5000);
            for (int i = 0; i < 32768; ++i) {
                int b = this.socketInputStream.read();
                if (b < 0) {
                    break;
                }
                os.write(b);
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {}
        }
        return os.toByteArray();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }
}

