/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AnnotationElement {
    public static final long UNKNOWN_POSITION = 0L;
    private static final long LINESHIFT = 32L;
    private static final long COLUMNMASK = 0xFFFFFFFFL;
    public final long position;

    public static int line(long pos) {
        return (int)(pos >>> 32);
    }

    public static int column(long pos) {
        return (int)(pos & 0xFFFFFFFFL);
    }

    public static long makePosition(int line, int column) {
        return ((long)line << 32) + (long)column;
    }

    public static String positionToString(long pos) {
        return AnnotationElement.line(pos) + "," + AnnotationElement.column(pos);
    }

    protected AnnotationElement(long position) {
        this.position = position;
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visit(this);
    }

    public static abstract class Visitor {
        public void visit(Annotation tree) {
            this.visit((AnnotationElement)tree);
        }

        public void visit(Attribute tree) {
            this.visit((AnnotationElement)tree);
        }

        public void visit(Array tree) {
            this.visit((AnnotationElement)tree);
        }

        public void visit(Identifier tree) {
            this.visit((AnnotationElement)tree);
        }

        public void visit(Literal tree) {
            this.visit((AnnotationElement)tree);
        }

        public void visit(AnnotationElement annotationElement) {
            throw new IllegalStateException("Unexpected annotation element: " + annotationElement);
        }
    }

    public static final class Literal
    extends Value {
        private final Object value;

        public Literal(long pos, Object value) {
            super(pos);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void acceptVisitor(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static final class Array
    extends Value {
        private final List<Value> values;

        public Array(long pos, List<Value> values) {
            super(pos);
            this.values = values;
        }

        public List<Value> getValues() {
            return this.values;
        }

        @Override
        public List<Object> getValue() {
            ArrayList<Object> valueList = new ArrayList<Object>(this.values.size());
            for (Value val : this.values) {
                valueList.add(val.getValue());
            }
            return valueList;
        }

        @Override
        public void acceptVisitor(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static final class Identifier
    extends Value {
        private final String identifier;

        public Identifier(long pos, String identifier) {
            super(pos);
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public String getValue() {
            return this.identifier;
        }

        @Override
        public void acceptVisitor(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static final class Attribute
    extends AnnotationElement {
        private final String name;
        private final Value value;

        public Attribute(long pos, String name, Value value) {
            super(pos);
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Value getValue() {
            return this.value;
        }

        @Override
        public void acceptVisitor(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static final class Annotation
    extends Value {
        public static final String DEFAULT_ATTRIBUTE = "value";
        private final String name;
        private final Map<String, Attribute> attributes;

        public Annotation(long pos, String name, Map<String, Attribute> attributes) {
            super(pos);
            this.name = name;
            this.attributes = attributes;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Attribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public Annotation getValue() {
            return this;
        }

        public Value getDefaultAttributeValue() {
            return this.getAttributeValue(DEFAULT_ATTRIBUTE);
        }

        public Value getAttributeValue(String attributeName) {
            Attribute attribute = this.attributes.get(attributeName);
            if (attribute == null) {
                throw new IllegalStateException("Attribute " + attributeName + " of annotation " + this.name + " is missing");
            }
            return attribute.value;
        }

        @Override
        public void acceptVisitor(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static abstract class Value
    extends AnnotationElement {
        protected Value(long pos) {
            super(pos);
        }

        public abstract Object getValue();
    }
}

