/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.modules;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class ModuleIdentifier
implements Serializable {
    private static final long serialVersionUID = 118533026624827995L;
    private static final String DEFAULT_SLOT = "main";
    private final String name;
    private final String slot;
    private final transient int hashCode;
    private static final Field hashField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field field;
            try {
                field = ModuleIdentifier.class.getDeclaredField("hashCode");
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
            return field;
        }
    });
    public static final ModuleIdentifier CLASSPATH = new ModuleIdentifier("Classpath", "main");

    private ModuleIdentifier(String name, String slot) {
        this.name = name;
        this.slot = slot;
        this.hashCode = ModuleIdentifier.calculateHashCode(name, slot);
    }

    private static int calculateHashCode(String name, String slot) {
        int h = 17;
        h = 37 * h + name.hashCode();
        h = 37 * h + slot.hashCode();
        return h;
    }

    public String getName() {
        return this.name;
    }

    public String getSlot() {
        return this.slot;
    }

    public boolean equals(Object other) {
        return other instanceof ModuleIdentifier && this.equals((ModuleIdentifier)other);
    }

    public boolean equals(ModuleIdentifier other) {
        return this == other || other != null && this.name.equals(other.name) && this.slot.equals(other.slot);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return ModuleIdentifier.escapeName(this.name) + ":" + ModuleIdentifier.escapeSlot(this.slot);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        try {
            hashField.setInt(this, ModuleIdentifier.calculateHashCode(this.name, this.slot));
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    private static String escapeName(String name) {
        StringBuilder b = new StringBuilder();
        boolean escaped = false;
        int i = 0;
        while (i < name.length()) {
            int c = name.codePointAt(i);
            switch (c) {
                case 58: 
                case 92: {
                    escaped = true;
                    b.append('\\');
                }
            }
            b.appendCodePoint(c);
            i = name.offsetByCodePoints(i, 1);
        }
        return escaped ? b.toString() : name;
    }

    private static String escapeSlot(String slot) {
        StringBuilder b = new StringBuilder();
        boolean escaped = false;
        int i = 0;
        while (i < slot.length()) {
            int c = slot.codePointAt(i);
            switch (c) {
                case 92: {
                    escaped = true;
                    b.append('\\');
                }
            }
            b.appendCodePoint(c);
            i = slot.offsetByCodePoints(i, 1);
        }
        return escaped ? b.toString() : slot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModuleIdentifier fromString(String moduleSpec) throws IllegalArgumentException {
        int c;
        if (moduleSpec == null) {
            throw new IllegalArgumentException("Module specification is null");
        }
        if (moduleSpec.length() == 0) {
            throw new IllegalArgumentException("Empty module specification");
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < moduleSpec.length()) {
            c = moduleSpec.codePointAt(i);
            if (c == 92) {
                b.appendCodePoint(c);
                i = moduleSpec.offsetByCodePoints(i, 1);
                if (i >= moduleSpec.length()) throw new IllegalArgumentException("Name has an unterminated escape");
                c = moduleSpec.codePointAt(i);
                b.appendCodePoint(c);
            } else {
                if (c == 58) {
                    if ((i = moduleSpec.offsetByCodePoints(i, 1)) != moduleSpec.length()) break;
                    throw new IllegalArgumentException("Slot is empty");
                }
                b.appendCodePoint(c);
            }
            i = moduleSpec.offsetByCodePoints(i, 1);
        }
        String name = b.toString();
        b.setLength(0);
        if (i >= moduleSpec.length()) return new ModuleIdentifier(name, DEFAULT_SLOT);
        do {
            c = moduleSpec.codePointAt(i);
            b.appendCodePoint(c);
        } while ((i = moduleSpec.offsetByCodePoints(i, 1)) < moduleSpec.length());
        return new ModuleIdentifier(name, b.toString());
    }

    public static ModuleIdentifier create(String name, String slot) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        if (slot == null) {
            slot = DEFAULT_SLOT;
        }
        return new ModuleIdentifier(name, slot);
    }

    public static ModuleIdentifier create(String name) {
        return ModuleIdentifier.create(name, null);
    }
}

