/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.modules;

import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityActions {
    private static final PrivilegedAction<ClassLoader> GET_LOADER_ACTION = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    SecurityActions() {
    }

    static ClassLoader setContextClassLoader(final ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    try {
                        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                        return classLoader2;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(classLoader);
                    }
                }
            });
        }
        try {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            return classLoader2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(GET_LOADER_ACTION);
        }
        return Thread.currentThread().getContextClassLoader();
    }
}

