/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.remoting3;

import infinispan.org.jboss.remoting3.Channel;
import infinispan.org.jboss.remoting3.LocalChannel;
import infinispan.org.jboss.remoting3.OpenListener;
import infinispan.org.jboss.remoting3.ServiceNotFoundException;
import infinispan.org.jboss.remoting3.security.UserInfo;
import infinispan.org.jboss.remoting3.spi.AbstractHandleableCloseable;
import infinispan.org.jboss.remoting3.spi.ConnectionHandler;
import infinispan.org.jboss.remoting3.spi.ConnectionHandlerContext;
import infinispan.org.jboss.remoting3.spi.ConnectionHandlerFactory;
import infinispan.org.jboss.remoting3.spi.ConnectionProvider;
import infinispan.org.jboss.remoting3.spi.ConnectionProviderContext;
import infinispan.org.jboss.remoting3.spi.SpiUtils;
import infinispan.org.xnio.Cancellable;
import infinispan.org.xnio.IoUtils;
import infinispan.org.xnio.OptionMap;
import infinispan.org.xnio.Result;
import infinispan.org.xnio.ssl.XnioSsl;
import java.net.SocketAddress;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;

final class LocalConnectionProvider
extends AbstractHandleableCloseable<ConnectionProvider>
implements ConnectionProvider {
    private final Executor executor;
    private final ConnectionProviderContext context;

    LocalConnectionProvider(ConnectionProviderContext context, Executor executor) {
        super(executor);
        this.context = context;
        this.executor = executor;
    }

    @Override
    public Cancellable connect(SocketAddress bindAddress, SocketAddress destination, OptionMap connectOptions, Result<ConnectionHandlerFactory> result, CallbackHandler callbackHandler, XnioSsl xnioSsl) throws IllegalArgumentException {
        this.context.accept(new ConnectionHandlerFactory(){

            @Override
            public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                return new LoopbackConnectionHandler(connectionContext);
            }
        });
        return IoUtils.nullCancellable();
    }

    @Override
    public Object getProviderInterface() {
        return NO_PROVIDER_INTERFACES;
    }

    public String toString() {
        return String.format("Remoting local connection provider %x for %s", this.hashCode(), this.context.getEndpoint());
    }

    private class LoopbackConnectionHandler
    extends AbstractHandleableCloseable<ConnectionHandler>
    implements ConnectionHandler {
        private final ConnectionHandlerContext context;

        LoopbackConnectionHandler(ConnectionHandlerContext context) {
            super(LocalConnectionProvider.this.executor);
            this.context = context;
        }

        @Override
        public Cancellable open(String serviceType, Result<Channel> result, OptionMap optionMap) {
            LocalChannel channel = new LocalChannel(LocalConnectionProvider.this.executor, this.context);
            try {
                OpenListener openListener = this.context.getServiceOpenListener(serviceType);
                if (openListener == null) {
                    throw new ServiceNotFoundException("Unable to find service type '" + serviceType + "'");
                }
                this.context.getConnectionProviderContext().getExecutor().execute(SpiUtils.getServiceOpenTask(channel.getOtherSide(), openListener));
            }
            catch (ServiceNotFoundException e) {
                result.setException(e);
                return IoUtils.nullCancellable();
            }
            result.setResult(channel);
            return IoUtils.nullCancellable();
        }

        @Override
        public Collection<Principal> getPrincipals() {
            return Collections.emptySet();
        }

        @Override
        public UserInfo getUserInfo() {
            return new UserInfo(){

                @Override
                public String getUserName() {
                    return null;
                }
            };
        }

        @Override
        public SSLSession getSslSession() {
            return null;
        }

        @Override
        public String getRemoteEndpointName() {
            return this.context.getConnectionProviderContext().getEndpoint().getName();
        }
    }
}

