/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio;

import infinispan.org.xnio.Cancellable;
import java.io.IOException;
import java.util.EventListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;

public interface IoFuture<T>
extends Cancellable {
    @Override
    public IoFuture<T> cancel();

    public Status getStatus();

    public Status await();

    public Status await(long var1, TimeUnit var3);

    public Status awaitInterruptibly() throws InterruptedException;

    public Status awaitInterruptibly(long var1, TimeUnit var3) throws InterruptedException;

    public T get() throws IOException, CancellationException;

    public T getInterruptibly() throws IOException, InterruptedException, CancellationException;

    public IOException getException() throws IllegalStateException;

    public <A> IoFuture<T> addNotifier(Notifier<? super T, A> var1, A var2);

    public static abstract class HandlingNotifier<T, A>
    implements Notifier<T, A> {
        @Override
        public void notify(IoFuture<? extends T> future, A attachment) {
            switch (future.getStatus()) {
                case CANCELLED: {
                    this.handleCancelled(attachment);
                    break;
                }
                case DONE: {
                    try {
                        this.handleDone(future.get(), attachment);
                        break;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException();
                    }
                }
                case FAILED: {
                    this.handleFailed(future.getException(), attachment);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public void handleCancelled(A attachment) {
        }

        public void handleFailed(IOException exception, A attachment) {
        }

        public void handleDone(T data, A attachment) {
        }
    }

    public static interface Notifier<T, A>
    extends EventListener {
        public void notify(IoFuture<? extends T> var1, A var2);
    }

    public static enum Status {
        WAITING,
        DONE,
        CANCELLED,
        FAILED;

    }
}

