/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.conduits;

import infinispan.org.xnio._private.Messages;
import infinispan.org.xnio.channels.StreamSinkChannel;
import infinispan.org.xnio.conduits.AbstractStreamSourceConduit;
import infinispan.org.xnio.conduits.ConduitReadableByteChannel;
import infinispan.org.xnio.conduits.Conduits;
import infinispan.org.xnio.conduits.StreamSourceConduit;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class InflatingStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit>
implements StreamSourceConduit {
    private final Inflater inflater;
    private final ByteBuffer buffer;

    public InflatingStreamSourceConduit(StreamSourceConduit next, Inflater inflater) {
        super(next);
        this.inflater = inflater;
        this.buffer = ByteBuffer.allocate(16384);
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(new ConduitReadableByteChannel(this), position, count);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return Conduits.transfer(this, count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int res;
        int remaining = dst.remaining();
        int position = dst.position();
        Inflater inflater = this.inflater;
        if (dst.hasArray()) {
            int res2;
            byte[] array = dst.array();
            int off = dst.arrayOffset();
            while (true) {
                try {
                    res2 = inflater.inflate(array, off + position, remaining);
                }
                catch (DataFormatException e) {
                    throw new IOException(e);
                }
                if (res2 > 0) {
                    dst.position(position + res2);
                    return res2;
                }
                if (inflater.needsDictionary()) {
                    throw Messages.msg.inflaterNeedsDictionary();
                }
                ByteBuffer buffer = this.buffer;
                buffer.clear();
                res2 = ((StreamSourceConduit)this.next).read(buffer);
                if (res2 <= 0) break;
                inflater.setInput(buffer.array(), buffer.arrayOffset(), res2);
            }
            return res2;
        }
        byte[] space = new byte[remaining];
        while (true) {
            try {
                res = inflater.inflate(space);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
            if (res > 0) {
                dst.put(space, 0, res);
                return res;
            }
            if (inflater.needsDictionary()) {
                throw Messages.msg.inflaterNeedsDictionary();
            }
            ByteBuffer buffer = this.buffer;
            buffer.clear();
            res = ((StreamSourceConduit)this.next).read(buffer);
            if (res <= 0) break;
            inflater.setInput(buffer.array(), buffer.arrayOffset(), res);
        }
        return res;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            ByteBuffer buffer = dsts[i + offset];
            if (!buffer.hasRemaining()) continue;
            return this.read(buffer);
        }
        return 0L;
    }

    @Override
    public void terminateReads() throws IOException {
        this.inflater.end();
        ((StreamSourceConduit)this.next).terminateReads();
    }

    @Override
    public void awaitReadable() throws IOException {
        if (!this.inflater.needsInput()) {
            return;
        }
        ((StreamSourceConduit)this.next).awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        if (!this.inflater.needsInput()) {
            return;
        }
        ((StreamSourceConduit)this.next).awaitReadable(time, timeUnit);
    }
}

