/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.nio;

import infinispan.org.xnio.Bits;
import infinispan.org.xnio.ChannelListeners;
import infinispan.org.xnio.IoUtils;
import infinispan.org.xnio.nio.NioHandle;
import infinispan.org.xnio.nio.NioUdpChannel;
import infinispan.org.xnio.nio.WorkerThread;
import java.io.Closeable;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;

final class NioUdpChannelHandle
extends NioHandle {
    private final NioUdpChannel channel;

    NioUdpChannelHandle(WorkerThread workerThread, SelectionKey selectionKey, NioUdpChannel channel) {
        super(workerThread, selectionKey);
        this.channel = channel;
    }

    @Override
    void handleReady(int ops) {
        try {
            if (ops == 0) {
                SelectionKey key = this.getSelectionKey();
                int interestOps = key.interestOps();
                if (interestOps != 0) {
                    ops = interestOps;
                } else {
                    this.forceTermination();
                    return;
                }
            }
            if (Bits.allAreSet(ops, 1)) {
                try {
                    ChannelListeners.invokeChannelListener(this.channel, this.channel.getReadListener());
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            if (Bits.allAreSet(ops, 4)) {
                try {
                    ChannelListeners.invokeChannelListener(this.channel, this.channel.getWriteListener());
                }
                catch (Throwable ignored) {}
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    void forceTermination() {
        IoUtils.safeClose((Closeable)this.channel);
    }

    @Override
    void terminated() {
        this.channel.invokeCloseHandler();
    }
}

