/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.sasl;

import infinispan.org.xnio.Buffers;
import infinispan.org.xnio.conduits.AbstractMessageSinkConduit;
import infinispan.org.xnio.conduits.Conduits;
import infinispan.org.xnio.conduits.MessageSinkConduit;
import infinispan.org.xnio.sasl.SaslWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class SaslWrappingConduit
extends AbstractMessageSinkConduit<MessageSinkConduit>
implements MessageSinkConduit {
    private final SaslWrapper wrapper;
    private ByteBuffer buffer;

    public SaslWrappingConduit(MessageSinkConduit next, SaslWrapper wrapper) {
        super(next);
        this.wrapper = wrapper;
    }

    @Override
    public boolean send(ByteBuffer src) throws IOException {
        if (!this.doSend()) {
            return false;
        }
        ByteBuffer wrapped = ByteBuffer.wrap(this.wrapper.wrap(src));
        if (!((MessageSinkConduit)this.next).send(wrapped)) {
            this.buffer = wrapped;
        }
        return true;
    }

    @Override
    public boolean send(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (!this.doSend()) {
            return false;
        }
        ByteBuffer wrapped = ByteBuffer.wrap(this.wrapper.wrap(Buffers.take(srcs, offs, len)));
        if (!((MessageSinkConduit)this.next).send(wrapped)) {
            this.buffer = wrapped;
        }
        return true;
    }

    @Override
    public boolean sendFinal(ByteBuffer src) throws IOException {
        return Conduits.sendFinalBasic(this, src);
    }

    @Override
    public boolean sendFinal(ByteBuffer[] srcs, int offs, int len) throws IOException {
        return Conduits.sendFinalBasic(this, srcs, offs, len);
    }

    private boolean doSend() throws IOException {
        ByteBuffer buffer = this.buffer;
        if (buffer != null && ((MessageSinkConduit)this.next).send(buffer)) {
            this.buffer = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean flush() throws IOException {
        return this.doSend() && ((MessageSinkConduit)this.next).flush();
    }
}

