/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.ssl;

import infinispan.org.xnio._private.Messages;
import infinispan.org.xnio.channels.StreamSinkChannel;
import infinispan.org.xnio.conduits.AbstractStreamSourceConduit;
import infinispan.org.xnio.conduits.ConduitReadableByteChannel;
import infinispan.org.xnio.conduits.Conduits;
import infinispan.org.xnio.conduits.StreamSourceConduit;
import infinispan.org.xnio.ssl.JsseSslConduitEngine;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;

final class JsseSslStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final JsseSslConduitEngine sslEngine;
    private volatile boolean tls;

    protected JsseSslStreamSourceConduit(StreamSourceConduit next, JsseSslConduitEngine sslEngine, boolean tls) {
        super(next);
        if (sslEngine == null) {
            throw Messages.msg.nullParameter("sslEngine");
        }
        this.sslEngine = sslEngine;
        this.tls = tls;
    }

    void enableTls() {
        this.tls = true;
        if (this.isReadResumed()) {
            this.wakeupReads();
        }
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(new ConduitReadableByteChannel(this), position, count);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return Conduits.transfer(this, count, throughBuffer, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int readResult;
        if (!this.tls) {
            return super.read(dst);
        }
        if (!this.sslEngine.isDataAvailable() && this.sslEngine.isInboundClosed() || this.sslEngine.isClosed()) {
            return -1;
        }
        Object object = this.sslEngine.getUnwrapLock();
        synchronized (object) {
            ByteBuffer unwrapBuffer = this.sslEngine.getUnwrapBuffer().compact();
            try {
                readResult = super.read(unwrapBuffer);
            }
            finally {
                unwrapBuffer.flip();
            }
        }
        int unwrapResult = this.sslEngine.unwrap(dst);
        if (unwrapResult == 0 && readResult == -1) {
            return -1;
        }
        return unwrapResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        int readResult;
        if (!this.tls) {
            return super.read(dsts, offs, len);
        }
        if (offs < 0 || offs > len || len < 0 || offs + len > dsts.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!this.sslEngine.isDataAvailable() && this.sslEngine.isInboundClosed() || this.sslEngine.isClosed()) {
            return -1L;
        }
        Object object = this.sslEngine.getUnwrapLock();
        synchronized (object) {
            ByteBuffer unwrapBuffer = this.sslEngine.getUnwrapBuffer().compact();
            try {
                readResult = super.read(unwrapBuffer);
            }
            finally {
                unwrapBuffer.flip();
            }
        }
        long unwrapResult = this.sslEngine.unwrap(dsts, offs, len);
        if (unwrapResult == 0L && readResult == -1) {
            return -1L;
        }
        return unwrapResult;
    }

    @Override
    public void resumeReads() {
        if (this.tls && this.sslEngine.isFirstHandshake()) {
            super.wakeupReads();
        } else {
            super.resumeReads();
        }
    }

    @Override
    public void terminateReads() throws IOException {
        if (this.tls) {
            super.suspendReads();
            return;
        }
        super.terminateReads();
    }

    @Override
    public void awaitReadable() throws IOException {
        if (this.tls) {
            this.sslEngine.awaitCanUnwrap();
        }
        if (this.sslEngine.isDataAvailable()) {
            return;
        }
        super.awaitReadable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        if (!this.tls) {
            super.awaitReadable(time, timeUnit);
            return;
        }
        Object object = this.sslEngine.getUnwrapLock();
        synchronized (object) {
            if (this.sslEngine.getUnwrapBuffer().hasRemaining()) {
                return;
            }
        }
        long duration = timeUnit.toNanos(time);
        long awaited = System.nanoTime();
        this.sslEngine.awaitCanUnwrap(time, timeUnit);
        awaited = System.nanoTime() - awaited;
        if (awaited > duration) {
            return;
        }
        super.awaitReadable(duration - awaited, TimeUnit.NANOSECONDS);
    }
}

